# SSD

## 环境配置

### Docker

推荐使用docker方式运行，提供拉取的docker镜像：

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
#-v挂载工作目录
docker run -it  --shm-size 80g --network=host --name=SSD --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310 bin/bash

```

安装docker中没有的依赖：

```bash
cd SSD
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
```


## 训练

### 数据集设置
#### VOC0712
数据集下载地址：
[SCNet](http://113.200.138.88:18080/aidatasets/voc0712/-/tree/Maintainers?ref_type=heads)

对于VOC0712数据集，文件结构如下（进入VOCdevkit0712/voc2007_2012/VOCdevkit即可）：
```
VOC_ROOT
|__ VOC2007
    |_ JPEGImages
    |_ Annotations
    |_ ImageSets
    |_ SegmentationClass
|__ VOC2012
    |_ JPEGImages
    |_ Annotations
    |_ ImageSets
    |_ SegmentationClass

在当前项目中，在`SSD/ssd/config/path_catlog.py`中第5行`DATA_DIR = '{数据集所在文件夹}/VOCdevkit0712/voc2007_2012/VOCdevkit'`修改数据集地址。

### 单DCU训练

```bash
export LD_LIBRARY_PATH=/opt/hayhal/hydm/lib:/opt/hayhal/lib:/opt/dtk-24.04.1/.hyhal/hydm/lib:$LD_LIBRARY_PATH
python train.py --config-file configs/vgg_ssd300_voc0712.yaml
```
### 多DCU训练

```bash
export NGPUS=4
python -m torch.distributed.launch --nproc_per_node=$NGPUS train.py --config-file configs/vgg_ssd300_voc0712.yaml SOLVER.WARMUP_FACTOR 0.03333 SOLVER.WARMUP_ITERS 1000
```
## 评估

### 单DCU评估

```bash
python test.py --config-file configs/vgg_ssd300_voc0712.yaml
```

### 多DCU评估

```bash
export NGPUS=4
python -m torch.distributed.launch --nproc_per_node=$NGPUS test.py --config-file configs/vgg_ssd300_voc0712.yaml
```

## 模型仓库
### COCO:

| Backbone       | Input Size  |          box AP                  | Model Size |  Download |
| :------------: | :----------:|   :--------------------------:   | :--------: | :-------: |
|  VGG16         |     300     |          25.2                    |  262MB     | [model](https://github.com/lufficc/SSD/releases/download/1.2/vgg_ssd300_coco_trainval35k.pth)   |
|  VGG16         |     512     |          29.0                    |  275MB     | [model](https://github.com/lufficc/SSD/releases/download/1.2/vgg_ssd512_coco_trainval35k.pth)   |

### PASCAL VOC:

| Backbone         | Input Size  |          mAP                     | Model Size | Download  |
| :--------------: | :----------:|   :--------------------------:   | :--------: | :-------: |
|  VGG16           |     300     |          77.7                    |   201MB    | [model](https://github.com/lufficc/SSD/releases/download/1.2/vgg_ssd300_voc0712.pth)  |
|  VGG16           |     512     |          80.7                    |   207MB    | [model](https://github.com/lufficc/SSD/releases/download/1.2/vgg_ssd512_voc0712.pth)  |
|  Mobilenet V2    |     320     |          68.9                    |   25.5MB   | [model](https://github.com/lufficc/SSD/releases/download/1.2/mobilenet_v2_ssd320_voc0712_v2.pth) |
|  Mobilenet V3    |     320     |          69.5                    |   29.9MB   | [model](https://github.com/lufficc/SSD/releases/download/1.2/mobilenet_v3_ssd320_voc0712.pth) |
|  EfficientNet-B3 |     300     |          73.9                    |   97.1MB   | [model](https://github.com/lufficc/SSD/releases/download/1.2/efficient_net_b3_ssd300_voc0712.pth) |



## 引用
如果你在研究中使用这个项目，请引用这个项目。
```text
 of SSD in PyTorch}},
    year = {2018},
    howpublished = {\url{https://github.com/lufficc/SSD}}
}
```
