# SOLOv2
## 论文
[SOLOv2](https://arxiv.org/abs/2003.10152)


## 模型简介
SOLO v2遵循了SOLO的优雅、简单的设计，并且针对mask的检测效果和运行效率做了两个改进：

（1）mask learning：能够更好地学习到mask;

（2）mask NMS：提出了matrix nms，大大减少了前向推理的时间。



## 环境依赖
- 列举基础环境需求，根据实际情况填写

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.1 |
| python | 3.11 |
| torch | 2.4.1+das.opt1.dtk25041 |


推荐使用镜像:
- 挂载地址 `-v` 根据实际模型情况修改

```bash
docker run -it --shm-size 50g --network=host --name solov2 --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/ image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04.1-py3.11 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：
```
pip install -r requirements.txt
```

## 数据集
[COCO](https://cocodataset.org/#home)


## 训练

### 单机训练
```bash
python tools/train.py ${CONFIG_FILE}

Example:
python tools/train.py configs/solo/solo_r50_fpn_8gpu_1x.py
```

### 多机训练
```bash
./tools/dist_train.sh ${CONFIG_FILE} ${GPU_NUM}

Example: 
./tools/dist_train.sh configs/solo/solo_r50_fpn_8gpu_1x.py  8
```

## 推理

### 单机推理
```bash
python tools/test_ins.py ${CONFIG_FILE} ${CHECKPOINT_FILE} --show --out  ${OUTPUT_FILE} --eval segm

Example: 
python tools/test_ins.py configs/solo/solo_r50_fpn_8gpu_1x.py  SOLO_R50_1x.pth --show --out  results_solo.pkl --eval segm
```

### 多机推理
```bash
./tools/dist_test.sh ${CONFIG_FILE} ${CHECKPOINT_FILE} ${GPU_NUM}  --show --out  ${OUTPUT_FILE} --eval segm

Example: 
./tools/dist_test.sh configs/solo/solo_r50_fpn_8gpu_1x.py SOLO_R50_1x.pth  8  --show --out results_solo.pkl --eval segm
```


### 精度
DCU与GPU精度一致

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| SOLO_R50_1x | 3.7GB | K100AI | 1 | [下载地址](https://huggingface.co/xinlongwang/SOLO/resolve/main/SOLOv2_R50_1x.pth?download=true) |
| SOLO_R50_3x | 3.7GB | K100AI | 1 | [下载地址](https://huggingface.co/xinlongwang/SOLO/resolve/main/SOLOv2_R50_3x.pth?download=true) |
| SOLO_R101_3x | 4.7GB | K100AI | 1 | [下载地址](https://huggingface.co/xinlongwang/SOLO/resolve/main/SOLOv2_R101_3x.pth?download=true) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/solov2-pytorch

## 参考资料
- https://github.com/WXinlong/SOLO
