# SmolLM3
## 论文
暂无

## 模型简介
SmolLM3是一个3B参数的语言模型，旨在突破小型模型的界限。它支持双模式推理、6种语言和长上下文。

<div align=center>
    <img src="./doc/arch.png"/>
</div>
该模型为仅解码器架构的Transformer模型，采用分组查询注意力机制与3:1比例的归一化位置编码，在包含网络文本、代码、数学及推理数据的阶段式课程学习框架下，使用11.2万亿token进行了预训练。后训练阶段包含1400亿token的中期推理专项训练，并依次进行了监督微调与基于锚点偏好优化的对齐训练。

### 主要特点
 
**完全开源模型：** 开放所有权重，并公开完整训练细节（含公开数据配比方案及训练配置）  
**长上下文支持：** 基于64K上下文长度训练，通过YARN外推法可扩展至128K token  
**多语言原生支持：** 覆盖英语、法语、西班牙语、德语、意大利语、葡萄牙语六种语言  





## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name smollm3 --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理
可参考vllm_serve.sh脚本
```bash
## serve启动

vllm serve HuggingFaceTB/SmolLM3-3B    --trust-remote-code --dtype bfloat16 --max-seq-len-to-capture 32768 -tp 1   --max-model-len 32768
## client访问
可参考vllm_cilent.sh
curl http://localhost:8000/v1/chat/completions     -H "Content-Type: application/json"     -d '{
        "model": "HuggingFaceTB/SmolLM3-3B",
        "messages": [
            {
                "role": "user",
                "content": "请介绍下自己."
                }
            ]
    }'
```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| SmolLM3-3B | 3B | K100AI | 1 | [下载地址](https://modelscope.cn/models/HuggingFaceTB/SmolLM3-3B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/smollm3_vllm

## 参考资料
- https://modelscope.cn/models/HuggingFaceTB/SmolLM3-3B
- https://huggingface.co/blog/smollm3