# SmallThinker
## 论文
暂无

## 模型简介
SmallThinker-3B-preview，是一个从Qwen2.5-3b-Instruct模型微调而来的新模型。基准性能如下：  
| 模型 |  AIME24 | AMC23 |GAOKAO2024_I | GAOKAO2024_II |MMLU_STEM | AMPS_Hard |math_comp |
| :------: | :------: | :------: | :------: | :------: | :------: | :------: | :------: |
| Qwen2.5-3B-Instruct | 6.67 | 45 | 50 | 35.8 | 59.8 | - | - |
| SmallThinker | 16.667 | 57.5 | 64.2 | 57.1 | 68.2 | 70 | 46.8 |
| GPT-4o | 9.3 | - | - | - | 64.2 | 57 | 50 |  

SmallThinker主要用于以下场景：
**边缘部署：** 通过将输出分类为安全、有争议和不安全三个严重级别，支持详细的风险评估，适应各种部署场景。
**QwQ-32B-Preview 基准测试原型：** SmallThinker可作为QwQ-32B-Preview大模型的高效轻量化草稿模型。测试数据显示，在llama.cpp框架中可实现约70%的推理加速（吞吐量从40token/s提升至70token/s）。。


## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name SmallThinker --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理
可参考vllm_serve.sh脚本
```bash
## serve启动

vllm serve PowerInfer/SmallThinker-3B-Preview   --trust-remote-code --dtype bfloat16 --max-seq-len-to-capture 32768 -tp 1   --max-model-len 32768
## client访问
可参考vllm_cilent.sh
curl http://localhost:8000/v1/chat/completions \
    -H "Content-Type: application/json" \
    -d '{
        "model": "PowerInfer/SmallThinker-3B-Preview",
        "messages": [
            {
                "role": "user",
                "content": "请介绍下自己."
                }
            ]
    }'
```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| SmallThinker-3B-Preview | 3B | K100AI | 1 | [下载地址](https://www.modelscope.cn/models/PowerInfer/SmallThinker-3B-Preview) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/smallthinker_vllm

## 参考资料
- https://www.modelscope.cn/models/PowerInfer/SmallThinker-3B-Preview
