# ShuffleNetV2

## 模型介绍

ShuffleNetV2 是一种轻量级神经网络模型，旨在提高深度学习模型的效率和速度。ShuffleNetV2 利用组卷积和通道重排等技术，在保持准确性的同时，将参数量和计算量大幅降低。

## 模型结构

ShuffleNetV2 的网络结构可以分为两个部分：基础网络和分类器。基础网络主要包含一系列 ShuffleNetV2 单元，用于提取图像特征；分类器则将提取的特征映射到类别概率上。

ShuffleNetV2 的基础网络由四个阶段组成，每个阶段都包含多个 ShuffleNetV2 单元。第一个阶段是一个简单的卷积层，用于进行卷积和池化操作，并将输入图像转换为高级特征图。接下来的三个阶段都采用了 ShuffleNetV2 单元，其中第二个和第三个阶段还引入了 Downsampling 和 Upsampling 机制，用于对特征图进行降维和升维操作。

在 ShuffleNetV2 单元中，逐点卷积（PointWise Convolution）和通道重排（Channel Shuffle）两个部分交替出现，以实现信息的混洗和传递。具体来说，逐点卷积用于将输入数据分为多个组，而通道重排则用于将不同组之间的特征图进行混洗，从而使得每个组都能够利用所有其他组的信息。

最后，在基础网络的末尾，ShuffleNetV2 使用了全局平均池化（Global Average Pooling）来将特征图降维为一个向量，然后通过全连接层将其映射到类别概率上。

## 数据集

在本测试中可以使用ImageNet数据集。

## ShuffleNetV2训练

### 环境配置

下载工程代码：

http://developer.hpccube.com/codes/aicomponent/mmclassification-mmcv.git

提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

* 训练镜像：docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
* pip install -r requirements.txt
* cd mmclassification    
* pip install -e .

### 训练

将训练数据解压到data目录下。

训练命令：

    ./shufflenet_v2.sh

## 准确率数据

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |          精度           |
| :--: | :---------------------: |
|  8   | top1:0.6960;top5:0.8895 |

### 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/shufflenet_v2-mmcv

### 参考

https://github.com/open-mmlab/mmpretrain