# SeResnet50

## 论文

Squeeze-and-Excitation Networks

- https://arxiv.org/pdf/1709.01507.pdf

## 模型介绍

SE-ResNet50是一种基于残差网络（ResNet）和注意力机制（SE）的深度卷积神经网络模型，是由微软亚洲研究院提出的，是一种高效、快速、准确的图像分类模型，具有广泛的应用前景。

![20231124110818](./images/20231124110818.png)

## 模型结构

Seresnet50的整体结构包括基础网络部分和Squeeze-and-Excitation(SE)模块。

![20231124111112](./images/20231124111112.png)

## 环境配置

### Docker

```python
git clone --recursive http://developer.hpccube.com/codes/modelzoo/seresnet50_mmcv.git
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
# <your IMAGE ID>用以上拉取的docker的镜像ID替换
docker run --shm-size 10g --network=host --name=nit-pytorch --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/Seresnet50_mmcv :/home/Seresnet50_mmcv -it <your IMAGE ID> bash

cd Seresnet50_mmcv/mmclassification-mmcv
pip install -r requirements.txt
```

## 数据集

在本测试中可以使用ImageNet数据集。

```
├── meta
├── train
├── val
```

### 训练

将训练数据解压到data目录下。

### 单机8卡

    ./seresnet50.sh

## 精度

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |          精度           |
| :--: | :---------------------: |
|  8   | top1:0.7754;top5:0.9373 |

## result

![img](https://developer.hpccube.com/codes/modelzoo/vit_pytorch/-/raw/master/image/README/1695381570003.png)

## 应用场景

### 算法类别

图像分类

### 热点行业

制造,能源,交通,网安

### 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/seresnet50_mmcv

### 参考

https://github.com/open-mmlab/mmpretrain