# SeResnet50

## 模型介绍

SE-ResNet50是一种基于残差网络（ResNet）和注意力机制（SE）的深度卷积神经网络模型，是由微软亚洲研究院提出的，是一种高效、快速、准确的图像分类模型，具有广泛的应用前景。

## 模型结构

Seresnet50的整体结构包括基础网络部分和Squeeze-and-Excitation(SE)模块。下面是该模型的详细结构：

1. 基础网络部分：Seresnet50的基础网络部分是一个深度为50层的卷积神经网络，由5个卷积块组成。每个卷积块中包含多个卷积层和一个池化层。该网络的输入是一张图片，输出是一个向量，表示图片的类别。

2. Squeeze-and-Excitation(SE)模块：SE模块在每个卷积块的最后一层添加。这个模块可以自适应地调整每个通道的权重，以便更好地捕捉有意义的特征。它包括两个步骤：

   - Squeeze操作：将卷积块的输出通过全局平均池化层(average pooling)压缩成一个1x1xC的向量（C是输出通道数）。

   - Excitation操作：将这个向量作为输入，传递到两个全连接层中进行处理，并使用sigmoid函数进行激活，生成一个1x1xC的权重向量。然后将这个权重向量应用于原始输出，以使网络更好地学习数据集的特定特征。

3. Residual Connection：在每个卷积块中，Seresnet50使用残差连接技术，将输入信息直接传递到后续层中。

总体来说，Seresnet50模型结构包括深度为50层的卷积神经网络，每个卷积块包含多个卷积层和一个池化层，以及Squeeze-and-Excitation(SE)模块和Residual Connection技术。

## 数据集

在本测试中可以使用ImageNet数据集。

## SeResnet50训练

### 环境配置

下载工程代码：

http://developer.hpccube.com/codes/aicomponent/mmclassification-mmcv.git

提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

* 训练镜像：docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
* pip install -r requirements.txt
* cd mmclassification    
* pip install -e .

### 训练

将训练数据解压到data目录下。

训练命令：

    ./seresnet50.sh

## 性能和准确率数据

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |       性能       |          精度           |
| :--: | :--------------: | :---------------------: |
|  8   | 1455.22samples/s | top1:0.7754;top5:0.9373 |

### 参考

https://github.com/open-mmlab/mmpretrain