# Sentence-BERT
## 论文
`Sentence-BERT: Sentence Embeddings using Siamese BERT-Networks`
- https://arxiv.org/pdf/1908.10084.pdf

## 模型结构

<div align=center>
    <img src="./doc/model.png"/>
</div>

## 算法原理
对于每个句子对，通过网络传递句子A和句子B，从而得到embeddings u 和 v。使用余弦相似度计算embedding的相似度，并将结果与 gold similarity score进行比较。这允许网络进行微调，并识别句子的相似性.

<div align=center>
    <img src="./doc/infer.png"/>
</div>

## 环境配置
1. -v 路径、docker_name和imageID根据实际情况修改
2. transformers/trainer_pt_utils.py文件 line 37 修改为:
```bash
try:
    from torch.optim.lr_scheduler import _LRScheduler as LRScheduler
except ImportError:
    from torch.optim.lr_scheduler import LRScheduler as LRScheduler
```
<div align=center>
    <img src="./doc/example.png"/>
</div>

### Docker（方法一）

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310

docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/sentence-bert_pytorch
pip install -r requirements.txt
pip install -U sentence-transformers
pip install -e .
```

### Dockerfile（方法二）

```bash
cd ./docker
cp ../requirements.txt requirements.txt

docker build --no-cache -t sbert:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/sentence-bert_pytorch
pip install -r requirements.txt
pip install -U sentence-transformers
pip install -e .
```

### Anaconda（方法三）
1. 关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装: https://developer.hpccube.com/tool/

```bash
DTK软件栈：dtk24.04
python：python3.10
torch：2.1.0
```

Tips：以上dtk软件栈、python、torch等DCU相关工具版本需要严格一一对应

2. 其他非特殊库直接按照requirements.txt安装

```bash
cd /your_code_path/sentence-bert_pytorch
pip install -r requirements.txt
pip install -U sentence-transformers
pip install -e .
```

## 数据集
使用来自多个数据集的結合来微调模型，句子对的总数超过10亿个句子。对每个数据集进行抽样，给出一个加权概率，该概率在data_config.json文件中详细说明。

因数据较多，这里仅用[Simple Wikipedia Version 1.0](https://cs.pomona.edu/~dkauchak/simplification/)数据集进行展示，数据集已在 datasets/simple_wikipedia_v1 中提供

详细数据请参考[all-MiniLM-L6-v2](https://huggingface.co/sentence-transformers/all-MiniLM-L6-v2)模型中的Model card。

数据集的目录结构如下:

```
├── datasets
│   ├──tmp.txt
│   ├──simple_wikipedia_v1
│       ├──simple_wiki_pair.txt # 生成的
│       ├──wiki.simple
│       └──wiki.unsimplified
```

## 训练
使用预训练模型[MiniLM-L6-H384-uncased](https://huggingface.co/nreimers/MiniLM-L6-H384-uncased)，有关预训练程序的详细信息，请参阅 model card。

### 单机多卡

```bash
bash finetune.sh
```

### 单机单卡

```bash
python finetune.py
```

## 推理
预训练模型下载[pretrained models](https://www.sbert.net/docs/pretrained_models.html)
```bash
python infer.py --data_path ./datasets/tmp.txt
```

## result

<div align=center>
    <img src="./doc/results.png"/>
</div>

### 精度
暂无

## 应用场景
### 算法类别
NLP

### 热点应用行业
教育,网安,政府

## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/sentence-bert_pytorch

## 参考资料
- https://github.com/UKPLab/sentence-transformers
