# Seed-Coder
## 论文
[SeedCoder](https://arxiv.org/abs/2506.03524)

## 模型简介
Seed-Coder，这是一个强大的、透明的、参数高效的开源代码模型家族，规模为8B，包括基础、指令和推理变体。Seed-Coder通过以下亮点推动了开源代码模型的发展。

**以模型为中心：** Seed-Coder主要利用LLM而不是手工编写的规则来过滤代码数据，最大限度地减少了预训练数据构建中的人工工作。
**透明：** 我们公开分享详细的模型中心数据管道见解，包括策划GitHub数据、提交数据和代码相关网络数据的方法。
**强大：** Seed-Coder在各种编码任务中实现了同类开源模型中的最佳性能。

![alt text](image.png)


## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm | 0.9.2 |
| torch | >=2.5.1 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name seed_coder --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/ docker pull image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理
```bash
## serve启动
export ALLREDUCE_STREAM_WITH_COMPUTE=1
export VLLM_MLA_DISABLE=0
export VLLM_USE_FLASH_MLA=1


vllm serve /path/of/ByteDance/Seed-Coder-8B-Instruct/ \
    --trust-remote-code \
    --max-model-len 32768 \
    --served-model-name seedcoder \
    --dtype bfloat16 \
    -tp 8

## client访问
curl http://localhost:8000/v1/chat/completions   \
    -H "Content-Type: application/json"  \
    -d '{
        "model": "seedcoder",
        "messages": [
            {
                "role": "user",
                "content": "写一个函数，功能是判断一个数是否是素数。"
            }
        ]
    }'
```

## 效果展示
<div align=center>
    <img src="./doc/results.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Seed-Coder-8B-Instruct | 8B | K100AI | 1| [下载地址](https://huggingface.co/ByteDance-Seed/Seed-Coder-8B-Instruct) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/seedcoder_vllm

## 参考资料
- https://github.com/ByteDance-Seed/Seed-Coder
