# Seed-OSS
## 论文
暂无

## 模型简介
Seed-OSS是字节跳动Seed团队于2025年8月开源的大型语言模型系列，包含三个版本（Seed-OSS-36B-Base、Seed-OSS-36B-Base-woSyn、Seed-OSS-36B-Instruct），基于Apache 2.0协议，支持长上下文处理、推理预算控制等特性。

### 核心特性
**‌超长上下文‌：** 原生支持512K tokens上下文，是主流模型（如DeepSeek V3.1的128K）的4倍，适用于法律文档、长篇报告等场景 。 ‌
**‌推理预算控制‌：** 用户可动态设定推理长度（如512、1K等），模型会实时反馈token使用情况 。 ‌
### ‌性能表现‌：
**MMLU-Pro：** 65.1分（超越Qwen2.5-32B的58.5分） 。 ‌
**AIME24：** 91.7分（开源模型SOTA） 。 ‌
**代码能力：** HumanEval 76.8分，MBPP 80.6分 。 ‌
### 技术架构
**参数规模：** 360亿参数，64层网络，15.5万词表 。 ‌
**关键技术：** 因果语言建模、分组查询注意力（GQA）、RoPE位置编码、SwiGLU激活函数 。 ‌

<div align=center>
    <img src="./doc/model_eval.png"/>
</div>



## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name seed_oss --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/ image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理
可参考vllm_serve.sh脚本
```bash
## serve启动


vllm serve /path/of/ByteDance-Seed/Seed-OSS-36B-Instruct/ \
    --trust-remote-code \
    --max-model-len 32768 \
    --served-model-name seed-oss \
    --dtype bfloat16 \
    -tp 2

## client访问
可参考vllm_cilent.sh
curl http://localhost:8000/v1/chat/completions   \
    -H "Content-Type: application/json"  \
    -d '{
        "model": "seed-oss",
        "messages": [
            {
                "role": "user",
                "content": "你是谁"
            }
        ]
    }'
```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Seed-OSS-36B-Instruct | 32B | BW1000 | 2 | [下载地址](https://huggingface.co/ByteDance-Seed/Seed-OSS-36B-Instruct) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/seed-oss_vllm

## 参考资料
- https://github.com/ByteDance-Seed/seed-oss
