# sd3.5

## 论文

`Scaling Rectified Flow Transformers for High-Resolution Image Synthesis`

* https://arxiv.org/abs/2403.03206

## 模型结构

sd3.5模型采用sd3相同的模型结构，具体来说使用了3个文本编码器，主干网络由`MM-DiT`组成。

<img src="readme_imgs/arch.png" style="zoom:70%">

## 算法原理

模型采用`flow matching`算法进行训练，与传统的扩散模型不同，Flow Matching直接优化整个轨迹，避免了逐步采样和反向过程，从而简化了训练过程并提高了生成效率。

<img src="readme_imgs/alg.png" style="zoom:100%">


## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu22.04-dtk24.04.2-py3.10

    docker run --shm-size 50g --network=host --name=sd3.5 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt

### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 50g --network=host --name=sd3.5 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt

### Anaconda (方法三)

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
https://developer.hpccube.com/tool/

    DTK驱动：dtk24.04.2
    python：python3.10
    torch: 2.1.0
    torchvision: 0.16.0

Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应

2、其它非特殊库参照requirements.txt安装

    pip install -r requirements.txt

## 数据集

无

## 训练

无

## 推理

```
export HF_ENDPOINT=https://hf-mirror.com
```

```bash
# Generate a cat using SD3.5 Large model (at models/sd3.5_large.safetensors) with its default settings
python sd3_infer.py --prompt "cute wallpaper art of a cat"
# Or use a text file with a list of prompts
python sd3_infer.py --prompt path/to/my_prompts.txt
# Generate a cat using SD3.5 Large Turbo with its default settings
python sd3_infer.py --prompt path/to/my_prompts.txt --model models/sd3.5_large_turbo.safetensors
```

## result

|model|prompt|result|
|:---:|:---:|:---:|
|large|cute wallpaper art of a dog|<img src="readme_imgs/result1.png" style="zoom:20%">
|turbo|cute wallpaper art of a dog|<img src="readme_imgs/result2.png" style="zoom:20%">|

### 精度

无

## 应用场景

### 算法类别

`AIGC`

### 热点应用行业

`电商,绘画,广媒`

## 预训练权重

large_mode: [huggingface](https://hf-mirror.com/stabilityai/stable-diffusion-3.5-large) | [SCNet高速下载通道](http://113.200.138.88:18080/aimodels/stabilityai/stable-diffusion-3.5-large)

large_turbo: [huggingface](https://hf-mirror.com/stabilityai/stable-diffusion-3.5-large-turbo) | [SCNet高速下载通道](http://113.200.138.88:18080/aimodels/stabilityai/stable-diffusion-3.5-large-turbo)

注意：仅需要按权重文件结构下载需要的权重即可，其中`clip_g, clip_l.safetensors, t5xxxl_fp16.safetensor`位于`text_encoders`目录下。

### 权重文件结构

```
models/
├── clip_g.safetensors
├── clip_l.safetensors
├── sd3.5_large.safetensors
├── sd3.5_large_turbo.safetensors
└── t5xxl_fp16.safetensors
```

## 源码仓库及问题反馈

* https://developer.sourcefind.cn/codes/modelzoo/sd3.5_pytorch

## 参考资料

* https://github.com/Stability-AI/sd3.5

