#!/usr/bin/env python3


# 导入run_auto_label工具, 初次运行会下载相关库文件
from modelscope.tools import run_auto_label
# 运行 autolabel进行自动标注，20句音频的自动标注约4分钟
import os 
import argparse


def wav_to_label(wav_data):
    work_dir = os.path.join(os.path.split(wav_data)[0], os.path.split(wav_data)[1]+"_autolabel")
    os.makedirs(work_dir, exist_ok=True)

    ret, report = run_auto_label(input_wav=wav_data,
                                work_dir=work_dir,
                                resource_revision='v1.0.7'
                                )
    # print(report)
    return report

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="wav2label")
    parser.add_argument("--wav_data", type=str, required=True, help="Path to wav data")
    args = parser.parse_args()

    wav_to_label(args.wav_data)