#! /usr/bin/env bash

# 可能微调train_max_steps需要传参--sed

# Function to display usage information
usage() {
    echo "Usage: $0 <valueA> <valueB> [<valueC>]"
    exit 1
}

target_rate=1.0

# Check if required parameters are provided  
if [ -z "$1" ] || [ -z "$2" ]; then  
    echo "Error: Missing required parameters."  
    usage
    exit 1  
fi  

#  Assign input parameters to variables
spk_wav="$1"
text="$2"

# Check if optional parameters are provided  
if [ -n "$3" ]; then  
    target_rate=$3  
fi
  
# Display the input parameters  
echo "spk_wav: $spk_wav"  
echo "text: $text"  
echo "target_rate: $target_rate"  

# Add your script logic here

# 数据自动标注
echo "**********************Start of wav to label**************************************"
echo "*********************************************************************************"
python3 wav_to_label.py --wav_data ${spk_wav}


# 特征提取
echo "**********************Start of feats extract**************************************"
echo "**********************************************************************************"
bash feats_extract.sh


# 训练声学模型
echo "**********************Start of train sambert**************************************"
echo "**********************************************************************************"
HIP_VISIBLE_DEVICES=0 python3 kantts/bin/train_sambert.py \
--model_config speech_personal_sambert-hifigan_nsf_tts_zh-cn_pretrain_16k/basemodel_16k/sambert/config.yaml \
--root_dir  training_stage/ptts_feats \
--stage_dir training_stage/ptts_sambert_ckpt \
--resume_path speech_personal_sambert-hifigan_nsf_tts_zh-cn_pretrain_16k/basemodel_16k/sambert/ckpt/checkpoint_*.pth


sambert_onnx_folder=sambert_onnx
mkdir "$sambert_onnx_folder"
hifigan_onnx_folder=hifigan_onnx  
mkdir "$hifigan_onnx_folder"

# 进行模型转换，运行一次pt模型。
echo "**********************Start of model transform**************************************"
echo "*************************************************************************************"
HIP_VISIBLE_DEVICES=0 python3 text_to_wav_trans.py \
--txt ${text} \
--output_dir res/ptts_syn_one \
--res_zip speech_personal_sambert-hifigan_nsf_tts_zh-cn_pretrain_16k/resource.zip \
--am_ckpt training_stage/ptts_sambert_ckpt/ckpt/checkpoint_2402200.pth \
--voc_ckpt speech_personal_sambert-hifigan_nsf_tts_zh-cn_pretrain_16k//basemodel_16k/hifigan/ckpt/checkpoint_2400000.pth \
--speaker F7 \
--se_file training_stage/ptts_feats/se/se.npy


# 运行合成语音
echo "**********************Start of text to wav*******************************************"
echo "*************************************************************************************"
HIP_VISIBLE_DEVICES=0 python3 text_to_wav_onnx.py \
--txt ${text} \
--output_dir res/ptts_syn \
--res_zip speech_personal_sambert-hifigan_nsf_tts_zh-cn_pretrain_16k/resource.zip \
--text_encoder_onnx sambert_onnx/text_encoder.onnx \
--variance_adaptor_pt sambert_onnx/variance_adaptor_dict.pt \
--mel_decoder_pt sambert_onnx/mel_decoder_dict.pt \
--mel_postnet_onnx sambert_onnx/mel_postnet.onnx \
--am_config training_stage/ptts_sambert_ckpt/config.yaml \
--voc_onnx hifigan_onnx/hifigan.onnx \
--voc_config speech_personal_sambert-hifigan_nsf_tts_zh-cn_pretrain_16k//basemodel_16k/hifigan/config.yaml \
--target_rate ${target_rate} \
--speaker F7 \
--se_file training_stage/ptts_feats/se/se.npy
