# sambert-hifigan_pytorch

## 论文
[RobuTrans: A Robust Transformer-Based Text-to-Speech Model](https://ojs.aaai.org/index.php/AAAI/article/view/6337)  
[HiFi-GAN: Generative Adversarial Networks for Efficient and High Fidelity Speech Synthesis](https://arxiv.org/abs/2010.05646)

## 模型结构
韵律建模sambert声学模型:在语音合成领域，类似FastSpeech的Parallel模型是目前的主流，它针对基频（pitch）、能量（energy）和时长（duration）三种韵律表征分别建模。但是，该类模型普遍存在一些效果和性能上的问题，例如，独立建模时长、基频、能量，忽视了其内在联系；完全非自回归的网络结构，无法满足工业级实时合成需求；帧级别基频和能量预测不稳定。 因此达摩院语音实验室设计了SAMBERT，一种基于Parallel结构的改良版TTS模型，它具有以下优点：
1. Backbone采用Self-Attention-Mechanism(SAM)，提升模型建模能力。
2. Encoder部分采用BERT进行初始化，引入更多文本信息，提升合成韵律。
3. Variance Adaptor对音素级别的韵律(基频、能量、时长)轮廓进行粗粒度的预测，再通过decoder进行帧级别细粒度的建模;并在时长预测时考虑到其与基频、能量的关联信息，结合自回归结构，进一步提升韵律自然度.
4. Decoder部分采用PNCA AR-Decoder[@li2020robutrans]，自然支持流式合成。
![sambert.jpg](assets%2Fsambert.jpg)

## 算法原理
如果需要进行迁移学习，那么需要先构建多说话人的声学模型，不同说话人是通过可训练的说话人编码（speaker embedding）进行区分的。给定新的一个说话人，一般通过随机初始化一个speaker embedding，然后再基于这个说话人的数据进行更新（见下图说话人空间1）。对于个性化语音合成来说，发音人的数据量比较少，学习难度很大，最终合成声音的相似度就无法保证。因此，我们采用说话人特征信息来表示每个说话人，此时，以少量说话人数据初始化的 speaker embedding 距离实际的目标说话人更近得多（见下图说话人空间2），学习难度小，此时合成声音的相似度就比较高。采用基于说话人特征信息的个性化语音合成，使得在20句条件下，依旧能够有较好的相似度。

![feature_space.png](assets%2Ffeature_space.png)
模型框架主要由三个部分组成：
1.数据自动化处理和标注
2.韵律建模SAMBERT声学模型
3.基于说话人特征信息的个性化语音合成
![ptts.png](assets%2Fptts.png)
## 环境配置

### Docker (方法一)

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk23.10-py38
# <your IMAGE ID>为以上拉取的docker的镜像ID替换
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name container_name imageID bash
cd /path/your_code_data/
```
KAN-TTS环境搭建：
```
git clone -b develop https://github.com/alibaba-damo-academy/KAN-TTS.git
cd KAN-TTS
```
安装相应的python依赖库：
```
pip3 install -r requirements.txt -f https://modelscope.oss-cn-beijing.aliyuncs.com/releases/repo.html
pip3 install pysptk,bitstring,unidecode,inflect
```
### Dockerfile(方式二)
```
docker build -t <image_name> .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name container_name image_name bash
cd /path/your_code_data/

```
之后参考方法一。

### Conda(方式三)

1. 创建conda虚拟环境：
```
conda create -n <env_name> python=3.8
```
2. 关于本项目DCU显卡所需的工具包、深度学习库等均可从[光合](https://www.hpccube.com/sso/login?service=https://developer.hpccube.com/tool/)开发者社区下载安装。  
DTK驱动：[dtk23.10](https://cancon.hpccube.com:65024/1/main/DTK-23.10)  
pytorch:[1.13.1](https://cancon.hpccube.com:65024/4/main/pytorch/dtk23.10)
<table><tr><td bgcolor=gray>Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应。</td></tr></table>
之后参考方法一。  

## 数据集

你可以从ModelScope下载经过阿里标准格式处理的AISHELL-3开源语音合成数据集，用来进行后续操作。如果你只有普通音频格式的数据，那么可以采用PTTS Autolabel自动化标注工具进行格式转换。

可参考的[训练数据](https://isv-data.oss-cn-hangzhou.aliyuncs.com/ics/MaaS/TTS/download_files/test_female.zip)，下载后解压到到目录如Data/ptts_spk0_wav下面。
数据集的目录结构如下：

```
ptts_spk0_wav
├─ SSB00180007.wav
├─ SSB00180012.wav
├─ ......
```
数据预处理包括两步：
1. autolabel自动标注
```
python3 wav_to_label.py --wav_data Data/ptts_spk0_wav
```
2. 特征提取
```
bash feats_extract.sh
```
注意修改相应的模型路径。  
特征提取只需要运行一小段时间，提取完毕后你会在training_stage/test_male_ptts_feats目录下得到如下结构的文件：
```
├── am_train.lst
├── am_valid.lst
├── audio_config.yaml
├── badlist.txt
├── data_process_stdout.log
├── duration
├── energy
├── f0
├── frame_energy
├── frame_f0
├── frame_uv
├── mel
├── raw_duration
├── raw_metafile.txt
├── Script.xml
├── se
├── train.lst
├── valid.lst
└── wav
```
## 训练

#### 单卡训练
```
HIP_VISIBLE_DEVICES=0 python3 kantts/bin/train_sambert.py \
--model_config speech_personal_sambert-hifigan_nsf_tts_zh-cn_pretrain_16k/basemodel_16k/sambert/config.yaml \
--root_dir  training_stage/ptts_feats \
--stage_dir training_stage/ptts_sambert_ckpt \
--resume_path speech_personal_sambert-hifigan_nsf_tts_zh-cn_pretrain_16k/basemodel_16k/sambert/ckpt/checkpoint_*.pth
```
注意修改相应的模型路径。
#### 单卡推理
```
HIP_VISIBLE_DEVICES=0 python3 kantts/bin/text_to_wav.py \
--txt Data/test.txt \
--output_dir res/ptts_syn \
--res_zip speech_personal_sambert-hifigan_nsf_tts_zh-cn_pretrain_16k/resource.zip \
--am_ckpt training_stage/ptts_sambert_ckpt/ckpt/checkpoint_2402200.pth \
--voc_ckpt speech_personal_sambert-hifigan_nsf_tts_zh-cn_pretrain_16k/basemodel_16k/hifigan/ckpt/checkpoint_2400000.pth \
--se_file training_stage/ptts_feats/se/se.npy
```
注意修改相应的模型路径。
## result
可在输出文件夹res/ptts_syn下找到克隆的语音文件。


## 应用场景
### 算法分类
语音处理

### 热点应用行业
制造,广媒,能源,医疗,家居,教育

### 预训练权重

```
git clone https://www.modelscope.cn/damo/speech_personal_sambert-hifigan_nsf_tts_zh-cn_pretrain_16k.git
```
## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/sambert-hifigan_pytorch

## 参考资料

[Modelscope - SambertHifigan](https://modelscope.cn/models/iic/speech_personal_sambert-hifigan_nsf_tts_zh-cn_pretrain_16k/summary)
