# sam2
## 论文
[SAM 2: Segment Anything in Images and Videos](https://arxiv.org/abs/2408.00714)

## 模型简介
Segment Anything Model 2 (SAM 2)是一个用于解决图像和视频中可提示视觉分割问题的基础模型。
将 SAM 扩展到视频领域，将图像视为单帧视频。该模型采用简单的 Transformer 架构，并利用流式内存实现实时视频处理。
官方构建了一个模型在环数据引擎，通过用户交互改进模型和数据，从而收集了迄今为止最大的视频分割数据集——SA-V 数据集。
在构建的数据集上训练的 SAM 2 在各种任务和视觉领域都表现出色。
<div align=center>
    <img src="./assets/model_diagram.png"/>
</div>

## 环境依赖

|      软件      | 版本 |
|:------------:| :------: |
|     DTK      | 25.04.2 |
|    python    | 3.10.12 |
|    torch     | 2.5.1+das.opt1.dtk25042 |

推荐使用镜像:
- 挂载地址`-v`，`{docker_name}`和 `{docker_image_name}`根据实际模型情况修改

```bash
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_path/:/path/your_code_path/ -v /opt/hyhal/:/opt/hyhal/:ro {docker_image_name} bash

#示例如下：
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.5.1-ubuntu22.04-dtk25.04.2-py3.10
docker run -it --shm-size 200g --network=host --name sam2 --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_path/:/path/your_code_path/ -v /opt/hyhal/:/opt/hyhal/:ro image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.5.1-ubuntu22.04-dtk25.04.2-py3.10 bash
#其余依赖
pip install e .
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照setup.py安装：
```
pip install e .
```

## 数据集
`暂无`

## 训练
`暂无`

## 推理

### pytorch
#### 单机推理
```bash
#Image prediction
cd checkpoints 
./download_ckpts.sh 
cd ..
HIP_VISIBLE_DEVICES=0 python image_predictor_example.py

```

## 效果展示
**单点结果** ：
Input:
- image:
<div align=center>
    <img src="./results/truck_points.png"/>
</div>

Output:
- mask_0_score_0.777

<div align=center>
    <img src="./results/truck_mask_0_score_0.777.png"/>
</div>

- mask_1_score_0.052

<div align=center>
    <img src="./results/truck_mask_1_score_0.052.png"/>
</div>

- tmask_2_score_0.652

<div align=center>
    <img src="./results/truck_mask_2_score_0.652.png"/>
</div>

**多点结果** 
Input:
- image:
<div align=center>
    <img src="./results/truck_multi_points.png"/>
</div>

- multi_points_mask_0_score_0.992
<div align=center>
    <img src="./results/truck_multi_points_mask_0_score_0.992.png"/>
</div>

**标注框** 

Input:
- image:
<div align=center>
    <img src="./results/truck_box.png"/>
</div>

- box_mask_0_score_0.977
<div align=center>
    <img src="./results/truck_box_mask_0_score_0.977.png"/>
</div>

### 精度
`DCU与GPU精度一致，推理框架：pytorch。`

## 预训练权重
|         模型名称         | 权重大小 | DCU型号  | 最低卡数需求 |下载地址|
|:--------------------:|:----:|:----------:|:------:|:----------:|
| sam2.1_hiera_tiny.pt |  149M  | BW1000|   1    | [Hugging Face](https://huggingface.co/facebook/sam2-hiera-tiny) |
| sam2.1_hiera_small.pt |  176M  | BW1000|   1    | [Hugging Face](https://huggingface.co/facebook/sam2.1-hiera-small) |
| sam2.1_hiera_base_plus.pt|  309M  | BW1000|   1    | [Hugging Face](https://huggingface.co/facebook/sam2-hiera-base-plus) |
| sam2.1_hiera_large.pt |  857M  | BW1000|   1    | [Hugging Face](https://huggingface.co/facebook/sam2.1-hiera-large) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/sam2_pytorch

## 参考资料
- https://github.com/facebookresearch/sam2
