# Salience-DETR
## 论文
`Salience DETR: Enhancing Detection Transformer with Hierarchical Salience Filtering Refinement`
- https://arxiv.org/abs/2403.16131
## 模型结构
显著性DETR采用了高性能的两阶段管道。
SlalenceDETR和主流的两阶段DETR类方法之间的主要架构区别在于变压器编码器和查询细化。
给定来自主干的多尺度特征，编码器仅更新基于显著性引导监督的层次查询过滤选择的查询。
通过查询细化模块，可以缓解查询之间的语义失调。
<div align=center>
    <img src="./docs/The architecture overview of Salience DETR.png"/>
</div>

## 算法原理
Salience DETR和主流的两阶段类DETR方法之间的主要架构差异在于detection transformer encoder 和 query refinement。主要包含以下几个部分：

(1)显著引导的监督

根据预测的置信度，查询过滤更新信息最丰富的查询，以以更少的计算负担实现类似的性能。从Focus DETR 中汲取灵感，为多尺度特性中的每个级别的查询提供监督。没有构建只分类前景和背景的离散标签{0,1}，而是构建了一个尺度独立的显著性作为监督目标来克服尺度偏差。

(2)层次查询过滤

Revisting query filtering in Focus DETR。Focus DETR引入了一个额外的分支，该分支通过对多尺度特征进行自上而下的分数调制来预测前景置信度。

(3)分层查询筛选

通常，高级标记比低级标记带来更少的计算负担，同时保留更多的信息语义。因此，除了传统的分层滤波外，一个自然的动机是引入分层滤波来处理多尺度特性。文章引入了两个集合作为相应的滤波比，对于第t个编码器层和第l个特征级，只有顶部的v*t*w*l*查询进行注意编码，而其他查询保持不变。

(4)跨级令牌融合

针对特定级别的过滤比率导致的不同级别查询的语义错位，文章提出了一种令牌融合模块，该模块利用路径聚合结构来处理跨级别的信息交互。在该模块中，通过提出的 RepVGGPluXBlock融合相邻的令牌，如图所示。

<div align=center>
    <img src="./docs/Cross-level token fusion.png"/>
</div>

## 环境配置
### Docker（方法一）
此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤，以及[光合](https://developer.hpccube.com/tool/)开发者社区深度学习库下载地址
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk23.10-py38 
docker run -it --shm-size=128G -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name salience_detr_pytorch  <your IMAGE ID> bash # <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：ffa1f63239fc
cd /path/your_code_data/salience_detr_pytorch
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple/  --trusted-host mirrors.aliyun.com

```
### Dockerfile（方法二）
此处提供dockerfile的使用方法
```
docker build --no-cache -t salience_detr:latest .
docker run -it --shm-size=128G -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name salience_detr_pytorch  salience_detr  bash
cd /path/your_code_data/salience_detr_pytorch
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple/  --trusted-host mirrors.aliyun.com

```
### Anaconda（方法三）
此处提供本地配置、编译的详细步骤，例如：

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
#DTK驱动：dtk23.10
# python：python3.8
# torch: 2.1.0
# torchvision: 0.16.0
conda create -n salience_detr python=3.8
conda activate salience_detr
pip install torch-2.1.0a0+git793d2b5.abi0.dtk2310-cp38-cp38-manylinux2014_x86_64.whl
pip install torchvision-0.16.0+git267eff6.abi0.dtk2310.torch2.1.0-cp38-cp38-manylinux2014_x86_64.whl
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它依赖环境安装如下：
```
cd /path/your_code_data/salience_detr_pytorch
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple/  --trusted-host mirrors.aliyun.com

```
## 数据集

请下载[COCO 2017](https://cocodataset.org/#home)([COCO 2017 SCNET快速下载地址](http://113.200.138.88:18080/aidatasets/coco2017))或将自己的数据集准备到data/中，并按如下方式组织它们。您可以使用tools/visualize_datasets.py可视化数据集注释以验证其正确性。


```
coco/
  ├── train2017/
  ├── val2017/
  └── annotations/
  	├── instances_train2017.json
  	└── instances_val2017.json
```

## 训练
使用accelerate原生处理多DCU的软件包，使用HIP_VISIBLE_DEVICES来指定DCU。如果未指定，脚本将使用节点上所有可用的DCU进行训练。
在训练前修改：configs/train_config.py文件中的配置包括coco数据集地址等参数

### 单机单卡
```
HIP_VISIBLE_DEVICES=0 accelerate launch main.py
```
### 单机多卡
```
HIP_VISIBLE_DEVICES=0,1,2,3 accelerate launch main.py
```

## 推理
在各种设置下使用 ResNet50 和 Swin-L 训练了 Salience DETR。以下为 COCO 2017 提供了相应的配置和检查点。

[salience_detr 模型权重SCNet快速下载链接如下](http://113.200.138.88:18080/aimodels/findsource-dependency/salience_detr)

### 训练12轮

| 模型          | 主干网                  |                                                                                                     下载                                                                                                     |
| ------------- | ----------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
| Salience DETR | ResNet50                |           [配置](configs/salience_detr/salience_detr_resnet50_800_1333.py) / [权重](https://github.com/xiuqhou/Salience-DETR/releases/download/v1.0.0/salience_detr_resnet50_800_1333_coco_1x.pth)           |
| Salience DETR | ConvNeXt-L              |         [配置](configs/salience_detr/salience_detr_convnext_l_800_1333.py) / [权重](https://github.com/xiuqhou/Salience-DETR/releases/download/v1.0.0/salience_detr_convnext_l_800_1333_coco_1x.pth)         |
| Salience DETR | Swin-L<sub>(IN-22K)     |             [配置](configs/salience_detr/salience_detr_swin_l_800_1333.py) / [权重](https://github.com/xiuqhou/Salience-DETR/releases/download/v1.0.0/salience_detr_swin_l_800_1333_coco_1x.pth)             |
| Salience DETR | FocalNet-L<sub>(IN-22K) | [配置](configs/salience_detr/salience_detr_focalnet_large_lrf_800_1333.py) / [权重](https://github.com/xiuqhou/Salience-DETR/releases/download/v1.0.0/salience_detr_focalnet_large_lrf_800_1333_coco_1x.pth) |
### 训练24轮

| 模型          | 主干网                   |                                                                                                     下载                                                                                                     |
| ------------- | -----------------------  | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
| Salience DETR | ResNet50               |           [配置](configs/salience_detr/salience_detr_resnet50_800_1333.py) / [权重](https://github.com/xiuqhou/Salience-DETR/releases/download/v1.0.0/salience_detr_resnet50_800_1333_coco_2x.pth)           |

### 单卡推理

注意--model-config和--checkpoint需要一一对应。

Inference:
```
# python inference.py --image-dir /path/to/images --model-config /path/to/model.py --checkpoint /path/to/checkpoint.pth --show-dir /path/to/dir
python inference.py --image-dir ./images --model-config configs/salience_detr/salience_detr_resnet50_800_1333.py --checkpoint checkpoint/salience_detr_resnet50_800_1333_coco_2x.pth --show-dir results
```

Evaluation/Test:

```
# CUDA_VISIBLE_DEVICES=<gpu_ids> accelerate launch test.py --coco-path /path/to/coco --model-config /path/to/model.py --checkpoint /path/to/checkpoint.pth

HIP_VISIBLE_DEVICES=0 accelerate launch test.py --coco-path ./data/coco --model-config configs/salience_detr/salience_detr_resnet50_800_1333.py --checkpoint checkpoint/salience_detr_resnet50_800_1333_coco_2x.pth

```


### 多卡推理

```
CUDA_VISIBLE_DEVICES=<gpu_ids> accelerate launch test.py --coco-path /path/to/coco --model-config /path/to/model.py --checkpoint /path/to/checkpoint.pth
HIP_VISIBLE_DEVICES=0,1,2,3 accelerate launch test.py --coco-path ./data/coco --model-config configs/salience_detr/salience_detr_resnet50_800_1333.py --checkpoint checkpoint/salience_detr_resnet50_800_1333_coco_2x.pth
```

## result
原图：
<div align=center>
    <img src="./docs/000000000139.jpg"/>
</div>

inference可视化结果如下：

<div align=center>
    <img src="./docs/000000000139_detr.jpg"/>
</div>


### 精度
使用四张DCU-K100卡推理


| 模型          | 主干网                  |  AP   | AP<sub>50 | AP<sub>75 | AP<sub>S | AP<sub>M | AP<sub>L |
| ------------- | ----------------------- | :---: | :-------: | :-------: | :------: | :------: | :------: |
| Salience DETR | ResNet50                | 50.0  |   67.7    |   54.2    |   33.3   |   54.4   |   64.4   |
| Salience DETR | ConvNeXt-L              | 54.2  |   72.4    |   59.1    |   38.8   |   58.3   |   69.6   |
| Salience DETR | Swin-L<sub>(IN-22K)     | 56.5  |   75.0    |   61.5    |   40.2   |   61.2   |   72.8   |
| Salience DETR | FocalNet-L<sub>(IN-22K) | 57.3  |   75.5    |   62.3    |   40.9   |   61.8   |   74.5   |


| 模型          | 主干网                  |  AP   | AP<sub>50 | AP<sub>75 | AP<sub>S | AP<sub>M | AP<sub>L |
| ------------- | ----------------------- | :---: | :-------: | :-------: | :------: | :------: | :------: | 
| Salience DETR | ResNet50                | 51.2  |   68.9    |   55.7    |   33.9   |   55.5   |   65.6   |


## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`科研,制造,医疗,家居,教育`
## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/salience_detr_pytorch
## 参考资料
- https://github.com/xiuqhou/Salience-DETR

