# RTMDet
## 论文
`RTMDet: An Empirical Study of Designing Real-Time Object Detectors`<br>
[论文链接](https://arxiv.org/abs/2212.07784)
## 模型结构
RTMDet 将 CSPDarkNet 作为基线，并使用同样构建单元组成的 CSPPAFPN 进行多尺度的特征融合，最后将特征输入给不同的检测头，进行目标检测、实例分割和旋转框检测等任务
![模型结构](./resources/moel_struct.jpg)
## 算法原理
宏观架构与yolo系列没有太大的区别，主要增加了构建基本单元的特征提取能力以及弹错模型不同的组件件的计算效率和精度平衡
对构建单元进行了更新
![model](./resources/model.jpg)
![构建单元](./resources/模块改进.jpg)
## 环境配置
### Docker（方法一）

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.8
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v /opt/hyhal:/opt/hyhal:ro --name docker_name imageID bash
cd /path/workspace/
pip install mmdet==3.2.0 -i https://mirrors.aliyun.com/pypi/simple/
```
### Dockerfile（方法二）
```
cd ./docker
docker build --no-cache -t mmdet:3.0 .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v /opt/hyhal:/opt/hyhal:ro --name docker_name imageID bash
cd /path/workspace/
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.sourcefind.cn/tool/
```
DTK软件栈: dtk24.04.1
python: python3.8
torch: 2.1.0
torchvision: 0.16.0+das1.1.git7d45932.abi1.dtk2404.torch2.1
mmcv: 2.0.1+das1.1.gite58da25.abi1.dtk2404.torch2.1.0

```

Tips：以上dtk软件栈、python、torch、mmcv等DCU相关工具版本需要严格一一对应

2、其他非特殊库直接按照requirements.txt安装

```
cd workspace/
pip install mmdet==3.2.0 -i https://mirrors.aliyun.com/pypi/simple/
```

## 数据集
COCO2017（在网络良好的情况下，如果没有下载数据集，程序会默认在线下载数据集）

[训练数据](http://images.cocodataset.org/zips/train2017.zip)

[验证数据](http://images.cocodataset.org/zips/val2017.zip)

[测试数据](http://images.cocodataset.org/zips/test2017.zip)

[标签数据](https://github.com/ultralytics/yolov5/releases/download/v1.0/coco2017labels.zip)

数据集的目录结构如下：

```
├── images 
│   ├── train2017
│   ├── val2017
│   ├── test2017
├── labels
│   ├── train2017
│   ├── val2017
├── annotations
│   ├── instances_val2017.json
├── LICENSE
├── README.txt 
├── test-dev2017.txt
├── train2017.txt
├── val2017.txt

```

## 训练
- 数据集放置位置默认为当前目录下 data/
- 如需要变更数据集目录 请修改 configs/\_base_\/datasets/coco_detection.py 下的 data_root
```python
bash ./train.sh
```
## 推理
- 可使用官方模型权重进行推理，也可使用自己训练模型权重进行推理
- 这里以官方模型推理举例[[下载地址：rtmdet_s_8xb32-300e_coco_20220905_161602-387a891e.pth](https://download.openmmlab.com/mmdetection/v3.0/rtmdet/rtmdet_s_8xb32-300e_coco/rtmdet_s_8xb32-300e_coco_20220905_161602-387a891e.pth)]
```python
# 官方推理代码
python demo/image_demo.py demo/demo.jpg ./configs/rtmdet/rtmdet_s_8xb32-300e_coco.py --weights rtmdet_s_8xb32-300e_coco_20220905_161602-387a891e.pth --device cuda
```
## result
![result](./resources/result.jpg)
### 精度
|  模型名称  | batchsize | amp混精 |  精度  |
|:------:|:---------:|:-----:|:----:|
|rtmdet-s|    256    |  off  | 44.5 |
|rtmdet-s|    256    |  on   | 44.5 |
## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`金融,交通,教育`
## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/rtmdet_mmcv
## 参考资料
- https://github.com/open-mmlab/mmdetection/tree/v3.2.0
