# RT-DETR
## 论文
`DETRs Beat YOLOs on Real-time Object Detection`
- https://arxiv.org/abs/2304.08069
## 模型结构
RT-DETR是一种端到端的实时物体检测器，它建立在视觉转换器（Vision Transformer）架构之上：
模型利用主干网络的最后三个阶段的输出特征{S3，S4，S5}作为编码器的输入；
混合编码器通过度内特征交互（AIFI）和跨尺度特征融合模块（CCFM）将多尺度特征转换成图像特征序列；
随后采用loU感知查询选择从编码器输出的特征序列中选择固定数量的特征，作为解码器的初始目标查询；
最后解码器通过辅助预测头迭代优化目标查询，生成边界框和置信度得分。
<div align=center>
    <img src="./doc/RT-DETR.PNG"/>
</div>

## 算法原理
1、主干网络：对于 backbone 部分，采用了经典的 ResNet 和可缩放的 HGNetv2 两种，两种 backbone 各训练了两个版本 ，以 HGNetv2 为 backbone 的 RT-DETR 包括 L 和 X 版本，以ResNet 为 backbone 的RT-DETR 则包括 RT-DETR-R50 和 RT-DETR-R101 。
RT-DETR-R50/101 做主干方便和现有的 DETR 变体进行对比，而 RT-DETR-HGNet-L/X 则用来和现有的实时检测器进行对比，值得注意的是，HGNetv2是由百度自家研发的主干结构。
与YOLO相似的地方在于，RT-DETR最终会输出三种不同尺寸的特征图，它们相对于输入图像的分辨率下采样倍数分别是 8 倍、16 倍和 32 倍。

2、混合编码器：RT-DETR 采用了一层 Transformer 的 Encoder ，其包括度内特征交互（AIFI）和跨尺度特征融合模块（CCFM）两部分。
它首先将二维的 S5 特征拉成向量，然后交给 AIFI 模块处理，其数学过程就是多头自注意力与 FFN，随后，再将输出 Reshape 回二维，记作 F5，以便去完成后续的所谓的“跨尺度特征融合”。
CCFM模块是由 2 个 1×1 卷积和 N 个 RepBlock 构成的，通过调整 CCFM 中 RepBlock 的数量和 Encoder 的编码维度分别控制 Hybrid Encoder 的深度和宽度，同时对 backbone 进行相应的调整即可实现检测器的缩放。

3、loU：在训练期间约束检测器对高 IoU 的特征产生高分类分数，对低 IoU 的特征产生低分类分数。从而使得模型根据分类分数选择的 Top-K 特征对应的预测框同时具有高分类分数和高 IoU 分数。

4、解码器：支持不同层数的灵活推理，无需重训练。

<div align=center>
    <img src="./doc/RT-DETR.PNG"/>
</div>

## 环境配置
### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.2-py3.10
docker run -it --name=RT-DETR --network=host --privileged=true --device=/dev/kfd --device=/dev/dri --shm-size=16G --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /path/your_code_data:/home/RT-DETR -v /opt/hyhal/:/opt/hyhal/:ro <imageID> bash  # <imageID>为以上拉取的docker的镜像ID替换

cd RT-DETR
# 安装依赖
pip config set global.index-url https://pypi.tuna.tsinghua.edu.cn/simple
pip install -r requirements.txt
```
### Dockerfile（方法二）
```
docker build --no-cache -t rtdetr:latest .
docker run -it --name=RT-DETR --network=host --privileged=true --device=/dev/kfd --device=/dev/dri --shm-size=16G --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /path/your_code_data:/home/RT-DETR -v /opt/hyhal/:/opt/hyhal/:ro rtdetr /bin/bash

cd RT-DETR
# 安装依赖
pip config set global.index-url https://pypi.tuna.tsinghua.edu.cn/simple
pip install -r requirements.txt
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装: https://developer.hpccube.com/tool/
```
DTK软件栈：dtk24.04.2
python：python3.10
pytorch：2.1.0
torchvision：0.16.0
onnxruntime：1.15.0
```
`Tips：以上dtk软件栈、python、pytorch等DCU相关工具版本需要严格一一对应`

2、其他非特殊库直接按照下面步骤进行安装
```
cd RT-DETR
# 安装依赖
pip config set global.index-url https://pypi.tuna.tsinghua.edu.cn/simple
pip install -r requirements.txt
```

## 数据集
### 训练数据集
`Coco2017`
仅需要annotations_trainval2017.zip、val2017.zip、train2017.zip作为数据集。可通过[scnet](http://113.200.138.88:18080/aidatasets/coco2017) 或[官网链接](https://cocodataset.org/#download) 进行下载，下载后的压缩包需要解压缩。通过官网下载和解压完整数据集的代码如下：

ps：本仓库内已准备了小数据集供训练测试，位于dataset/

```
cd RT-DETR/datasets
wget -i url.txt
# 解压
apt-get update
apt-get install unzip
unzip annotations_trainval2017.zip;unzip val2017.zip;unzip train2017.zip
```
数据集目录结构如下：
```
RT-DETR/datasets:
 ── train2017
    │   └── ...
 ── val2017
    │   └── ...
 ── annotations
    │   └── ...
```
### 推理数据集
推理测试所用数据已保存在RT-DETR/datasets/000000033109.jpg

## 训练
运行代码时会默认下载辅助模型，存储目录为/root/.cache/torch/hub/checkpoints/

### 单机多卡
```
cd RT-DETR
HIP_VISIBLE_DEVICES=0,1,2,3;torchrun --nproc_per_node=4 rtdetr_pytorch/tools/train.py -c rtdetr_pytorch/configs/rtdetr/rtdetr_r18vd_6x_coco.yml
# -c 配置文件路径
# -r 恢复训练的权重加载路径
```
注：如果挂载目录不是"/home/RT-DETR",需要修改RT-DETR/rtdetr_pytorch/configs/dataset/coco_detection.yml和RT-DETR/rtdetr_pytorch/configs/rtdetr/rtdetr_r18vd_6x_coco.yml中的对应路径。

## 推理
权重可通过[scnet](http://113.200.138.88:18080/aimodels/findsource-dependency/rt-detrv1/-/tree/main/pytorch) 或 [官网链接](https://github.com/lyuwenyu/storage/releases/tag/v0.1)进行下载，通过官网下载的代码如下：
```
cd RT-DETR
wget -i model/url.txt -P model/
```
onnx_infer.py内可以修改onnx模型目录和数据集目录，推理代码如下：
```
cd RT-DETR

# 1、导出onnx文件，以r18vd_6x为例
HIP_VISIBLE_DEVICES=0 python rtdetr_pytorch/tools/export_onnx.py \
	-c rtdetr_pytorch/configs/rtdetr/rtdetr_r101vd_6x_coco.yml \
	-r model/rtdetr_r101vd_6x_coco_from_paddle.pth \
	-f model/onnx/rtdetr_r101vd_6x_coco.onnx \
	--check
# -c 模型配置文件的存储目录
# -r 源模型的目录
# -f onnx模型的导出目录
# --check 检查onnx模型是否导出完成

# 2、运行推理
python onnx_infer.py
```
注：如果挂载目录不是"/home/RT-DETR",需要修改RT-DETR/rtdetr_pytorch/configs/dataset/coco_detection.yml和RT-DETR/rtdetr_pytorch/configs/rtdetr/rtdetr_r18vd_6x_coco.yml中的对应路径。

## 评估
评估代码如下：
```
CUDA_VISIBLE_DEVICES=0,1,2,3 torchrun --nproc_per_node=4 rtdetr_pytorch/tools/train.py \
	-c rtdetr_pytorch/configs/rtdetr/rtdetr_r101vd_6x_coco.yml \
	-r model/rtdetr_r101vd_6x_coco_from_paddle.pth \
	--test-only
# -c 配置文件路径
# -r 权重加载路径
# --test-only 只进行评估
```

## result
默认推理结果为：
<div align=center>
    <img src="./doc/inference_result.png"/>
</div>

### 精度
|                              | 测试参数                        | 软件栈     | final loss |
| ---------------------------- | ------------------------------- | ---------- | ---------- |
| A800 * 4 （80G，1410 Mhz）   | config=rtdetr_r18vd_6x_coco.yml | cuda11.8   | 9.390466   |
| k100ai * 4 （64G，1400 Mhz） | config=rtdetr_r18vd_6x_coco.yml | dtk24.04.2 | 9.400760   |

## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`制造,交通,电商,广媒,医疗`
## 预训练权重
- http://113.200.138.88:18080/aimodels/findsource-dependency/rt-detrv1/-/tree/main/pytorch
- https://github.com/lyuwenyu/storage/releases/tag/v0.1
## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/rt-detr_pytorch
## 参考资料
- https://github.com/huangb23/VTimeLLM
