# RoboBrain
## 论文
[RoboBrain: A Unified Brain Model for Robotic Manipulation from Abstract to Concrete](https://arxiv.org/abs/2502.21257)

## 模型结构
模型基于qwen2.5进行构建。
<div align=center>
    <img src="./doc/model.png"/>
</div>

## 算法原理
在实际应用中，该模型首先生成详细的计划，然后将其拆分为子任务描述以执行具体的机器人任务。
<div align=center>
    <img src="./doc/methods.png"/>
</div>

## 环境配置
### 硬件需求

DCU型号：K100_AI,节点数量：1台,卡数：2 张。

`-v 路径`、`docker_name`和`imageID`根据实际情况修改

### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:vllm0.8.5-ubuntu22.04-dtk25.04-rc7-das1.5-py3.10-20250612-fixpy-rocblas0611-rc2
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/robobrain_pytorch
```

### Dockerfile（方法二）
```bash
cd docker
docker build --no-cache -t robobrain:latest .
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/robobrain_pytorch
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04
python: 3.10
vllm: 0.8.5
torch: 2.4.1+das.opt2.dtk2504
deepspeed: 0.14.2+das.opt2.dtk2504
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

## 数据集
无

## 训练
暂无

## 推理
### vllm推理方法
#### server

server启动
```bash
vllm serve BAAI/RoboBrain --served-model-name robobrain --max_model_len 16384 -tp 2 --limit_mm_per_prompt image=2
```

client访问
```bash
python client.py
```

## result
<div align=center>
    <img src="./doc/results-dcu.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 应用场景
### 算法类别
文本理解

### 热点应用行业
制造,广媒,家居,教育

## 预训练权重
- [BAAI/RoboBrain](https://huggingface.co/BAAI/RoboBrain)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/robobrain_pytorch

## 参考资料
- https://github.com/FlagOpen/RoboBrain.git
