# RIDCP

## 论文

**RIDCP: Revitalizing Real Image Dehazing via High-Quality Codebook Priors**

* https://arxiv.org/pdf/2304.03994.pdf

## 模型结构


ridcp先使用Encoder对输入进行特征提取得到Z，特征Z流向$`G_{vq}`$以及G，流向$`G_{vq}`$的Z被替换(CHM方法)为码本中的特征$`Z_{vq}`$，然后$`Z_{vq}`$通过$`G_{vq}`$获取各个层的特征$`F^i_{vq}`$，通过G获取到的特征$`F^i`$通过与$`F^i_{vq}`$的特征进行融合(NFA方法)得到新的特征$`F^i`$，直至G的最后一层，得到目标输出。

![img.png](imgs/img.png)
![img_2.png](imgs/img_2.png)


## 算法原理


用途：该算法通过有效利用先验知识（码本）来完成图像去雾功能。

原理：

1. 融合特征(NFA)，消除仅使用码本特征导致的图像失真；
2. 使用CHM（距离计算方式）匹配更好的码本特征。


**NFA**

![Alt text](imgs/nfa1.png)

![Alt text](imgs/nfa2.png)

**CHM**

![Alt text](imgs/chm1.png)

![Alt text](imgs/chm2.png)

![Alt text](imgs/chm3.png)


这里 $`\hat{z}`$代表通过Encoder获取到的特征, $`z_k`$代表码本中的第k个特征，$`\alpha`$ 有最佳值21.25，$`f^k_h`$与$`f^k_c`$为统计值。

## 环境配置


### Docker (方法一)

    docker pull FROM image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk-23.04-py38-latest
    docker run --shm-size 10g --network=host --name=ridcp --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -it 2bb84d403fac bash   <your IMAGE ID>
    pip install -r requirements.txt
    BASICSR_EXT=True python setup.py develop

### Dockerfile (方法二)
    
    # 需要在对应的目录下
    docker build -t <IMAGE_NAME>:<TAG> .
    # <your IMAGE ID>用以上拉取的docker的镜像ID替换
    docker run -it --shm-size 10g --network=host --name=ridcp --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined 
    <your IMAGE ID> bash
    BASICSR_EXT=True python setup.py develop
    

### Anaconda (方法三)
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
https://developer.hpccube.com/tool/

    DTK驱动：dtk23.04
    python：python3.8
    torch:1.13.1
    torchvision:0.14.1
    torchaudio:0.13.1
    deepspeed:0.9.2
    apex:0.1

Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应

2、其它非特殊库参照requirements.txt安装

    pip install -r requirements.txt

3、其他

    BASICSR_EXT=True python setup.py develop

Tips: 使用阿里的pip源


## 数据集

下载地址（训练集）：https://pan.baidu.com/s/1oX3AZkVlEa7S1sSO12r47Q （提取码：qqqo）


    datasets
        |- clear_images_no_haze_no_dark_500
            |- xxx.jpg
            |- ...
        |- depth_500
            |- xxx.npy
            |- ...

下载地址（测试集）：https://sites.google.com/view/reside-dehaze-datasets/reside-%CE%B2


    RTTS
        |- Annotations
            |- xxx.xml
            |- ...
        |- ImageSets
            |- Main
                |- xxx.txt
                |- ...
        |- JPEGImages
            |- xxx.png
            |- ...
        

## 训练

模型下载：https://pan.baidu.com/s/1ps9dPmerWyXILxb6lkHihQ  （HQPs，CHM，提取码：huea）

    # 这里的X表示设备编号，如0，1，2，3
    CUDA_VISIBLE_DEVICES=X,X,X,X python basicsr/train.py -opt options/RIDCP.yml

## 推理

模型下载：https://pan.baidu.com/s/1ps9dPmerWyXILxb6lkHihQ  （RIDCP，提取码：huea）

    python inference_ridcp.py -i examples -w pretrained_models/pretrained_RIDCP.pth -o results --use_weight --alpha -21.25
    
参数说明：
1. -i <路径>: 输入的图片或者文件夹
2. -w <路径>: 模型参数
3. -o <路径>: 处理完后的结果路径


## result


上图是输入图像，下图是输出图像

![img_6.png](imgs/img_6.png)


### 精度

|platform|FADE|BRISQUE|NIMA|
|:---|:---:|:---:|:---:|
|DCU|0.845|17.295|5.0|
|GPU|0.944|18.782|4.4267|

注意：FADE与BRISQUE的值越小越好，NIMA的值越大越好。


## 应用场景


### 算法类别

`图像去雾`

### 热点应用行业
`交通,医疗,环保,气象`

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/ridcp_pytorch

## 参考资料

* https://github.com/RQ-Wu/RIDCP_dehazing
