<!--
 * @Author: zhuww
 * @email: zhuww@sugon.com
 * @Date: 2023-06-14 17:07:00
 * @LastEditTime: 2023-06-14 20:40:00
-->
# RFDesign
## 模型介绍
RFDesign基于Rosetta(一个广泛应用于蛋白质结构预测和蛋白质设计的开源软件包)开发,支持蛋白质分子设计任务，使用预先训练的蛋白质模型来预测和优化蛋白质的稳定性和功能。
## 模型结构
RFDesign是一个使用Rosetta软件实现的蛋白质设计方法,模型结构包括特征提取器，用于从蛋白质序列和结构中提取特征的;序列-结构耦合模型,用于将蛋白质的序列信息和结构信息进行耦合，以捕捉它们之间的关联性；功能评估器,用于评估蛋白质的功能性;优化器用于对蛋白质进行优化，以改善其稳定性和功能。
## 数据集
此处介绍使用的数据集


## 推理
### 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取推理的docker镜像：
* 推理镜像：docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:rfdesign-dtk22.10-patch4-py39-latest

激活镜像环境：
`source /opt/dtk-22.10/env.sh`

测试目录：
`/opt/RFDesign`

### 推理
推理版本：
* Pytorch(DCU版本) >= 1.10.0a0
* Dgl(DCU版本) >= 0.9.1
* TensorFlow2(DCU版本) >= 2.7.0
* Jax(DCU版本) >= 0.2.21


#### 下载权重

    cd /opt/RFDesign/hallucination/weights/rf_Nov05
    wget http://files.ipd.uw.edu/pub/rfdesign/weights/BFF_last.pt

    cd /opt/RFDesign/inpainting/weights/
    wget http://files.ipd.uw.edu/pub/rfdesign/weights/BFF_mix_epoch25.pt


##### hallucination
基于hallucination的测试命令：

    cd /opt/RFDesign/hallucination/tests/
    ./run_tests.sh  # 结果默认保存在/opt/RFDesign/hallucination/tests/output

参数说明：--pdb是输入的pdb文件，--out是结果保存路径，--len是hallucination蛋白的长度范围, --contigs是以逗号分隔的pdb范围列表来参考pdb,--steps是逗号分隔的优化步骤数列表,--num是是设计数量

##### inpainting
基于inpainting的测试命令：

    cd /opt/RFDesign/inpainting/tests/
    ./run_tests.sh  # 结果默认保存在/opt/RFDesign/hallucination/tests/out

参数说明：--pdb是输入的pdb文件，--contigs是要保存的输入蛋白质片段,--out 是结果保存路径,--dump_all是将所有可能的输出转存到结果保存路径(若不需要，可去掉该参数),--n_cycle是通过RFold回收的数量,--num_designs是设计数量

#### 准备输入和后处理以及hallucination评分结果
运行hallucination或inpainting后，首先生成一个带侧链的松弛模型(.fas、.pdb、.npz、.trb 文件),该步骤需要.pdb和.npz文件，完成后，会生成一个FOLDER/trf_relax文件夹(包含松弛结构的pdb)

    cd /opt/RFDesign/scripts
    ./trf_relax.sh FOLDER  # FOLDER包含hallucination或inpainting的结果
    

##### AlphaFold2
根据hallucination设计模型和模板结构，进行AlphaFold2预测和计算RMSD:

    ./af2_metrics.py FOLDER/trf_relax # 修改第241行的data_dir为自己的alphafold2数据集路径

该步骤会将AF2模型输出到FOLDER/trf_relax/af2/,并将指标输出到FOLDER/af2_metrics.csv

##### Pyrosetta指标

    ./pyrosetta_metrics.py FOLDER/trf_relax

该步骤会计算hallucination（RoseTTAFold）设计模型和参考结构之间的RMSD，以及回转半径、二级结构、拓扑结构（即HHH或HEEH）

##### 在PyMOL中对齐模型
使设计与受限区域上的参考结构对齐的pymol会话:

    ./pymol_align.py -- -o OUTPUT.pse FOLDER/*pdb

该步骤会在当前文件夹中创建一个名为OUTPUT.pse的会话,其中包含来自REFERENCE.pdb的原始结构，所有设计都与FOLDER/*.pdb对齐

## 准确率数据
测试数据：`/opt/RFDesign/hallucination/tests`和`/opt/RFDesign/inpainting/tests/2KL8.pdb`，使用的加速卡:1张 DCU Z100L-32G

hallucination准确率数据：
| pdb | af2_lddt | rmsd_af2_des | contig_rmsd_af2_des | contig_rmsd_af2 |
| :------: | :------: | :------: | :------: | :------: |
| C3d_relaxed | 63.826 | 18.537 | 16.375 | 16.435 | 
| pd1 | 48.188 | 5.731 | 3.110 | 3.527 | 
| rsvf-v_5tpn | 75.460 | 2.685 | 1.536 | 3.917 |  
| 2KL8 | 89.197 | 0.813 | 0.824 | 0.865 |

## 源码仓库及问题反馈
* [https://developer.hpccube.com/codes/modelzoo/rfdesign_rosetta](https://developer.hpccube.com/codes/modelzoo/rfdesign_rosetta) 

## 参考
* [https://github.com/RosettaCommons/RFDesign](https://github.com/RosettaCommons/RFDesign) 
