// SSD定义

#ifndef __SSD_DEFINITION_H__
#define __SSD_DEFINITION_H__

#include <vector>

namespace migraphxSamples
{

#define SSD_MAX_PRIORBOX_LAYER_NUM 10 // 能够支持的最大检测层数量

// SSD参数
typedef struct _SSDParameter
{
    int numberOfPriorBoxLayer; // 检测层数量

    // Model Parameters
    int convHeight[SSD_MAX_PRIORBOX_LAYER_NUM * 2];
    int convWidth[SSD_MAX_PRIORBOX_LAYER_NUM * 2];
    int convChannel[SSD_MAX_PRIORBOX_LAYER_NUM * 2];

    // PriorBoxLayer Parameters
    int priorBoxWidth[SSD_MAX_PRIORBOX_LAYER_NUM];   // 每个检测层priorbox的宽
    int priorBoxHeight[SSD_MAX_PRIORBOX_LAYER_NUM];  // 每个检测层priorbox的高
    std::vector<std::vector<float>> priorBoxMinSize; // 每个检测层priorbox的minsize
    std::vector<std::vector<float>> priorBoxMaxSize; // 每个检测层priorbox的maxsize
    int minSizeNum[SSD_MAX_PRIORBOX_LAYER_NUM];      // 每个检测层priorbox的minsize数量
    int maxSizeNum[SSD_MAX_PRIORBOX_LAYER_NUM];      // 每个检测层priorbox的maxsize数量
    int srcImageHeight;                              // 原图大小
    int srcImageWidth;
    int inputAspectRatioNum[SSD_MAX_PRIORBOX_LAYER_NUM];  // 每个检测层宽高比的数量
    std::vector<std::vector<float>> priorBoxAspectRatio;  // 每个检测层的宽高比
    float priorBoxStepWidth[SSD_MAX_PRIORBOX_LAYER_NUM];  // 每个检测层步长的宽
    float priorBoxStepHeight[SSD_MAX_PRIORBOX_LAYER_NUM]; // 每个检测层步长的高
    float offset;
    int flip[SSD_MAX_PRIORBOX_LAYER_NUM];
    int clip[SSD_MAX_PRIORBOX_LAYER_NUM];
    int priorBoxVar[4];

    // SoftmaxLayer Parameters
    int softMaxInChn[SSD_MAX_PRIORBOX_LAYER_NUM];
    int softMaxInHeight;
    int concatNum;
    int softMaxOutWidth;
    int softMaxOutHeight;
    int softMaxOutChn;

    // DetectionOutLayer Parameters
    int classNum; // 类别数(包含背景类)
    int topK;
    int keepTopK;
    int NMSThresh;
    int confThresh;
    int detectInputChn[SSD_MAX_PRIORBOX_LAYER_NUM];
    int convStride[SSD_MAX_PRIORBOX_LAYER_NUM];

    // buffer
    int* buffer;
    int* classification[SSD_MAX_PRIORBOX_LAYER_NUM]; // 分类数据
    int* regression[SSD_MAX_PRIORBOX_LAYER_NUM];     // 回归
    int* priorboxOutputData;
    int* softMaxOutputData;
    int* getResultBuffer;
    int* dstScore;
    int* dstRoi;
    int* classRoiNum;
    _SSDParameter()
        : srcImageHeight(0),
          srcImageWidth(0),
          offset(0.0),
          softMaxInHeight(0),
          concatNum(0),
          softMaxOutWidth(0),
          softMaxOutHeight(0),
          softMaxOutChn(0),
          buffer(NULL),
          priorboxOutputData(NULL),
          softMaxOutputData(NULL),
          getResultBuffer(NULL),
          dstScore(NULL),
          dstRoi(NULL),
          classRoiNum(NULL)
    {
    }
} SSDParameter;

typedef struct _QuickSortStack
{
    int min;
    int max;
} QuickSortStack;

} // namespace migraphxSamples

#endif
