# RetinaFace

## 论文

RetinaFace: Single-stage Dense Face Localisation in the Wild

- https://arxiv.org/pdf/1905.00641.pdf

## 模型结构

RetinaFace是一个经典的人脸检测模型, 采用SSD架构进行人脸检测。

<img src="./Doc/Image/RetinaFace_01.png" style="zoom:70%;" align=center>

## 算法原理

RetinaFace模型有几个主要特点：

- 采用 FPN 特征金字塔提取多尺度特征；
- 引入 SSH 算法的 Context Modeling；
- 多任务训练，提供额外的监督信息。

<img src="./Doc/Image/RetinaFace_04.png" style="zoom:70%;" align=center>

## 环境配置

### Docker（方法一）

拉取镜像：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/migraphx:4.3.0-ubuntu20.04-dtk24.04.1-py3.8
```

创建并启动容器：

```
docker run --shm-size 16g --network=host --name=retinaface_migraphx -v /opt/hyhal:/opt/hyhal:ro --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/retinaface_migraphx:/home/retinaface_migraphx -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

### Dockerfile（方法二）

```
cd ./docker
docker build --no-cache -t retinaface_migraphx:2.0 .

docker run --shm-size 16g --network=host --name=retinaface_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/retinaface_migraphx:/home/retinaface_migraphx -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集

根据提供的样本数据，进行人脸检测。

## 推理

### Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

#### 设置环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

#### 安装依赖

```
# 进入python示例目录
cd <path_to_retinaface_migraphx>/Python

# 安装依赖
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
```

#### 运行示例

RetinaFace模型的推理示例程序是RetinaFace_infer_migraphx.py，在python目录下使用如下命令运行该推理示例：

```
python RetinaFace_infer_migraphx.py 
```

### C++版本推理

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。


#### 构建工程

```
rbuild build -d depend
```

#### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

```
export LD_LIBRARY_PATH=<path_to_retinaface_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

#### 运行示例

成功编译RetinaFace工程后，执行如下命令运行该示例：

```
# 进入retinaface migraphx工程根目录
cd <path_to_retinaface_migraphx> 

# 进入build目录
cd ./build/

# 执行示例程序
./RetinaFace
```

## result

### Python版本

python程序运行结束后，会在当前目录生成RetinaFace检测结果图像。

<img src="./Resource/Images/Result_2.jpg" alt="Result_2" style="zoom:67%;" />

### C++版本

C++程序运行结束后，会在build目录生成RetinaFace人脸检测结果图像。

<img src="./Resource/Images/Result_1.jpg" alt="Result" style="zoom:67%;" />

### 精度

无

## 应用场景

### 算法类别

`人脸检测`

### 热点应用行业

`金融`,`交通`,`教育`

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/retinaface_migraphx

## 参考资料

https://github.com/biubug6/Pytorch_Retinaface
