# RetinaFace

## 模型介绍

RetinaFace是一个经典的人脸检测模型(https://arxiv.org/abs/1905.00641)，采用了SSD架构。

## 模型结构

RetinaFace模型 有几个主要特点：

- 采用 FPN 特征金字塔提取多尺度特征；
- 引入 SSH 算法的 Context Modeling；
- 多任务训练，提供额外的监督信息。

## 推理

### 环境配置

在[光源](https://www.sourcefind.cn/#/image/dcu/custom)可拉取用于推理的docker镜像，RetinaFace 模型推理推荐的镜像如下：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort_dcu_1.14.0_migraphx2.5.2_dtk22.10.1
```

在[光合开发者社区](https://cancon.hpccube.com:65024/4/main/)可下载MIGraphX安装包，python依赖安装：

```
pip install -r requirements.txt
```

安装DTK版的Pytorch和torchvision，下载地址：https://cancon.hpccube.com:65024/4/main/pytorch，https://cancon.hpccube.com:65024/4/main/vision

### 运行示例

RetinaFace模型的推理示例程序是RetinaFace_infer_migraphx.py，使用如下命令运行该推理示例：

```
python RetinaFace_infer_migraphx.py 
```

程序运行结束会在当前目录生成RetinaFace检测结果图像。

<img src="./curve/Result.jpg" alt="Result" style="zoom: 50%;" />

## 历史版本

​		https://developer.hpccube.com/codes/modelzoo/retinaface_migraphx

## 参考

​		https://github.com/biubug6/Pytorch_Retinaface
