# RetinaFace

## 模型介绍

RetinaFace是一个经典的人脸检测模型(https://arxiv.org/abs/1905.00641), 采用了SSD架构。

## 模型结构

RetinaFace模型 有几个主要特点：

- 采用 FPN 特征金字塔提取多尺度特征；
- 引入 SSH 算法的 Context Modeling；
- 多任务训练，提供额外的监督信息。

## python版本推理

下面介绍如何运行python代码示例，具体推理代码解析，在Doc/Tutorial_Python.md中有详细说明。

### 拉取镜像

在光源可拉取推理的docker镜像，RetinaFace工程推荐的镜像如下：

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 推理示例

RetinaFace模型的推理示例程序是RetinaFace_infer_migraphx.py，进入python文件夹使用如下命令运行该推理示例：

```
# 进入python示例目录
cd <path_to_retinaface_migraphx>/Python

# 安装依赖
pip install -r requirements.txt

# 运行程序
python RetinaFace_infer_migraphx.py 
```

程序运行结束会在当前目录生成RetinaFace检测结果图像。

<img src="./Resource/Images/Result_2.jpg" alt="Result_2" style="zoom:67%;" />

## C++版本推理

下面介绍如何运行C++代码示例，具体推理代码解析，在Doc/Tutorial_Cpp.md目录中有详细说明。

参考Python版本推理中的构建安装，在光源中拉取推理的docker镜像。

### 安装Opencv依赖

```python
cd <path_to_migraphx_samples>
sh ./3rdParty/InstallOpenCVDependences.sh
```

### 修改CMakeLists.txt

- 如果使用ubuntu系统，需要修改CMakeLists.txt中依赖库路径：
  将"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/"修改为"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/"

- **MIGraphX2.3.0及以上版本需要c++17**


### 安装OpenCV并构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

**Centos**:

```
export LD_LIBRARY_PATH=<path_to_retinaface_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

**Ubuntu**:

```
export LD_LIBRARY_PATH=<path_to_retinaface_migraphx>/depend/lib/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

### 推理示例

成功编译RetinaFace工程后，执行如下命令运行该示例：

```
# 进入migraphx samples工程根目录
cd <path_to_retinaface_migraphx> 

# 进入build目录
cd ./build/

# 执行示例程序
./RetinaFace
```

程序运行结束会在build目录生成RetinaFace人脸检测结果图像。

<img src="./Resource/Images/Result_1.jpg" alt="Result" style="zoom:67%;" />

## 历史版本

​		https://developer.hpccube.com/codes/modelzoo/retinaface_migraphx

## 参考

​		https://github.com/biubug6/Pytorch_Retinaface
