# ResNet50v1.5
## 论文

该模型是ResNet50v1模型的修改版本，和之前版本的区别在于，在需要下采样的瓶颈模块中，v1在第一次1x1卷积中的stride=2，而v1.5在3x3卷积中的stride=2

v1版本论文如下：

`Deep Residual Learning for Image Recognition`

- [https://arxiv.org/pdf/1512.03385.pdf](https://arxiv.org/pdf/1512.03385.pdf)

该模型的初始化过程如下面论文中所述：

`Delving Deep into Rectifiers: Surpassing Human-Level Performance on ImageNet Classification`

- [https://arxiv.org/pdf/1502.01852.pdf](https://arxiv.org/pdf/1502.01852.pdf)

## 模型结构
ResNet50v1.5是一个具有50个卷积层的深度残差神经网络模型，它通过残差连接和批归一化层来实现更深层次的特征提取和优化训练。

![ResNet50](ResNet50.png)


## 算法原理
ResNet50v1.5的算法原理是利用残差连接和深层卷积层来构建更深的神经网络，解决梯度消失和模型退化问题，从而实现更好的特征提取和模型优化。

![Residual_Block](Residual_Block.png)


## 环境配置
### Docker（方法一）
此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10

docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

```
### Dockerfile（方法二）
此处提供dockerfile的使用方法
```
cd ./docker
docker build --no-cache -t resnet:v1.5 .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

```
### Anaconda（方法三）
此处提供本地配置、编译的详细步骤，例如：

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```
DTK驱动：dtk24.04.1
python：python3.10
torch：2.1.0
torchvision：0.16.0
```
`Tips：以上dtk驱动、python、pytorch等DCU相关工具版本需要严格一一对应`
另外需要安装如下三方库

## 数据集
Imagenet

- https://image-net.org/

参考[scrips/extract_ILSVRC.sh](https://developer.sourcefind.cn/codes/modelzoo/resnet50-pytorch/-/blob/main/scrips/extract_ILSVRC.sh)处理数据集，处理后数据集结构如下：

```
data
    |
    train
        |
        n01440764
        n01443537
        ...
    val
        |
        n01440764
        n01443537
        ...
```

## 训练

在运行脚本过程中根据实际情况修改相关脚本的数据集路径及log文件命名
### 单机单卡(fp16)

```
bash train_single_fp16.sh
```

### 单机多卡(fp16)

```
bash train_multi_fp16.sh
```

### 单机单卡(fp32)

```
bash train_single_fp32.sh
```

### 单机多卡(fp32)

```
bash train_multi_fp32.sh
```



## result

![result](result.png)

### 精度

测试数据：Imagenet，使用的加速卡:Z100L。

根据测试结果情况填写表格：
| 卡数 | Top1 | Top5 |
| :------: | :------: | :------: |
| 4 | 78.6% | 94.12% |
## 应用场景
### 算法类别
`图像分类`

### 热点应用行业
`制造,政府,科研`

## 源码仓库及问题反馈
- [https://developer.sourcefind.cn/codes/modelzoo/resnet50v1.5_pytorch](https://developer.sourcefind.cn/codes/modelzoo/resnet50v1.5_pytorch)
## 参考资料
- [https://github.com/NVIDIA/DeepLearningExamples/tree/master/PyTorch/Classification/ConvNets/resnet50v1.5](https://github.com/NVIDIA/DeepLearningExamples/tree/master/PyTorch/Classification/ConvNets/resnet50v1.5)
