---
name: "[Official Model] Bug Report"
about: Use this template for reporting a bug for the “official” directory
labels: type:bug,models:official

---

# Prerequisites

Please answer the following questions for yourself before submitting an issue.

- [ ] I am using the latest TensorFlow Model Garden release and TensorFlow 2.
- [ ] I am reporting the issue to the correct repository. (Model Garden official or research directory)
- [ ] I checked to make sure that this issue has not been filed already.

## 1. The entire URL of the file you are using

https://github.com/tensorflow/models/tree/master/official/...

## 2. Describe the bug

A clear and concise description of what the bug is.

## 3. Steps to reproduce

Steps to reproduce the behavior.

## 4. Expected behavior

A clear and concise description of what you expected to happen.

## 5. Additional context

Include any logs that would be helpful to diagnose the problem.

## 6. System information

- OS Platform and Distribution (e.g., Linux Ubuntu 16.04):
- Mobile device name if the issue happens on a mobile device:
- TensorFlow installed from (source or binary):
- TensorFlow version (use command below):
- Python version:
- Bazel version (if compiling from source):
- GCC/Compiler version (if compiling from source):
- CUDA/cuDNN version:
- GPU model and memory:

<!-- 
Collect system information using our environment capture script.
https://github.com/tensorflow/tensorflow/tree/master/tools/tf_env_collect.sh

You can also obtain the TensorFlow version with:

1. TensorFlow 1.0
`python -c "import tensorflow as tf; print(tf.GIT_VERSION, tf.VERSION)"`

2. TensorFlow 2.0
`python -c "import tensorflow as tf; print(tf.version.GIT_VERSION, tf.version.VERSION)"`
-->
