# Copyright 2022 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Backbones configurations."""

import dataclasses

from official.modeling import hyperparams
from official.vision.beta.configs import backbones


@dataclasses.dataclass
class Hourglass(hyperparams.Config):
  """Hourglass config."""
  model_id: int = 52
  input_channel_dims: int = 128
  num_hourglasses: int = 2
  initial_downsample: bool = True
  activation: str = 'relu'


@dataclasses.dataclass
class Backbone(backbones.Backbone):
  hourglass: Hourglass = Hourglass()
