## Contributing to KerasCV

Patches to KerasCV are welcome!

The source-of-truth repository lives under
[TF Model Garden Vision](https://github.com/tensorflow/models/official/vision/keras_cv),
and is mirrored as a read-only repository under
[keras-team/keras-cv](https://github.com/keras-team/keras-cv).
Contributions should be made as PRs to the TF Model Garden repository.
This is to ensure the codebase is rigorously tested with state-of-art models
on different accelerators.
In the long run, we will move development to the current repository `keras-team/keras-cv`.

## :heavy_check_mark: Contributor checklist

1. Ensure you have signed the [Contributor License Agreement](https://cla.developers.google.com/about/google-individual?csw=1).
    * All code contributors are required to sign a Contributor License Agreement.
    * Please read this [troubleshooting guide](Contributor-License-Agreements#troubleshooting-clas)
    if you encounter an issue.
2. Please review the [contribution guidelines](https://github.com/tensorflow/models/wiki/How-to-contribute).
3. Check if your changes are consistent with the [TensorFlow coding style](https://www.tensorflow.org/community/contribute/code_style).
