# Copyright 2022 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Lint as: python3
"""RetinaNet configuration definition."""
import dataclasses
from typing import Optional

from official.core import config_definitions as cfg
from official.core import exp_factory
from official.projects.qat.vision.configs import common
from official.vision.configs import retinanet
from official.vision.configs.google import backbones


@dataclasses.dataclass
class RetinaNetTask(retinanet.RetinaNetTask):
  quantization: Optional[common.Quantization] = None


@exp_factory.register_config_factory('retinanet_spinenet_mobile_coco_qat')
def retinanet_spinenet_mobile_coco() -> cfg.ExperimentConfig:
  """Generates a config for COCO OD RetinaNet for mobile with QAT."""
  config = retinanet.retinanet_spinenet_mobile_coco()
  task = RetinaNetTask.from_args(
      quantization=common.Quantization(), **config.task.as_dict())
  task.model.backbone = backbones.Backbone(
      type='spinenet_mobile',
      spinenet_mobile=backbones.SpineNetMobile(
          model_id='49',
          stochastic_depth_drop_rate=0.2,
          min_level=3,
          max_level=7,
          use_keras_upsampling_2d=True))
  config.task = task

  return config
