# ResNet50

## 论文
`Deep Residual Learning for Image Recognition`
- https://arxiv.org/abs/1512.03385
## 模型结构
ResNet50网络中包含了49个卷积层、1个全连接层等

![img](./doc/ResNet50.png)
## 算法原理
ResNet50使用了多个具有残差连接的残差块来解决梯度消失或梯度爆炸问题，并使得网络可以向更深层发展。

![img](./doc/Residual_Block.png)
## 环境配置
### Docker(方法一)
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/tensorflow:2.11.0-centos7.6-dtk23.10-py310
# <Your Image ID>用上面拉取docker镜像的ID替换
docker run --shm-size 16g --network=host --name=resnet50_tensorFlow --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/resnet50_tensorflow:/home/resnet50_tensorflow -it <Your Image ID> bash
pip install -r requirements.txt --no-deps
wget  https://cancon.hpccube.com:65024/directlink/1/DTK-23.10/hyhal.tar.gz
tar -xzf hyhal.tar.gz -C /opt/
```
### Dockerfile(方法二)
```
cd resnet50_tensorflow/docker
docker build --no-cache -t resnet50_tensorflow:latest .
docker run --rm --shm-size 16g --network=host --name=resnet50_tensorflow --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/../../resnet50_tensorflow:/home/resnet50_tensorflow -it resnet50_tensorflow:latest bash

```
### Anaconda(方法三)
1、关于本项目DCU显卡所需的特殊深度学习库可以从开发者社区下载安装：
https://developer.hpccube.com/tool/
```
DTK版本：dtk23.10
python:  3.10
tensorflow: 2.13.1
tf-models-official: 2.13
keras: 2.13.1
tensorboard: 2.13
hyhal
```
`Tips:以上dtk、python、tensorflow等DCU相关工具版本需要严格一一对应`

2、其他非特殊库参照requirements.txt安装
```
pip3 install -r requirements.txt  --no-deps
```

## 数据集

1、真实数据

使用ImageNet数据集，并且需要转成TFRecord格式
ImageNet数据集可以[官网](https://image-net.org/ "ImageNet数据集官网")下载、百度搜索或者联系我们
ImageNet数据集转成TFRecord格式，可以参考以下[script](https://github.com/tensorflow/tpu/blob/master/tools/datasets/imagenet_to_gcs.py)和[README](https://github.com/tensorflow/tpu/tree/master/tools/datasets#imagenet_to_gcspy)
制作完成的TFRrecord数据形式如下：
```
tfrecord-imagenet
                | 
                train-00000-of-01024
                train-00001-of-01024
                ...
                train-01022-of-01024
                train-01023-of-01024
                validation-00000-of-00128
                validation-00001-of-00128
                ...
                validation-00126-of-00128
                validation-00127-of-00128
```
2、合成数据

基于随机合成的数据，不需要下载ImageNet数据集，执行网络训练时只需要把程序执行语句中的--use_synthetic_data设置为true即可

## 训练
### fp32训练
#### 单机单卡训练命令：

不打开xla:

    export PYTHONPATH=/home/resnet50_tensorFlow:$PYTHONPATH  
    python3 official/legacy/image_classification/resnet/resnet_ctl_imagenet_main.py --data_dir=/path/to/{ImageNet-tensorflow_data_dir} --model_dir=/path/to/{model_save_dir} --batch_size=128 --num_gpus=1  --use_synthetic_data=false  --train_epochs=90  --dtype=fp32

打开xla:
    
    export PYTHONPATH=/home/resnet50_tensorflow:$PYTHONPATH
    TF_XLA_FLAGS="--tf_xla_auto_jit=1" python3 official/legacy/image_classification/resnet/resnet_ctl_imagenet_main.py --data_dir=/path/to/{ImageNet-tensorflow_data_dir} --model_dir=/path/to/{model_save_dir} --batch_size=128 --num_gpus=1  --use_synthetic_data=false  --train_epochs=90  --dtype=fp32

#### 单机四卡训练指令：
不打开xla:

    export PYTHONPATH=/home/resnet50_tensorflow:$PYTHONPATH
    python3 official/legacy/image_classification/resnet/resnet_ctl_imagenet_main.py --data_dir=/path/to/{ImageNet-tensorflow_data_dir} --model_dir=/path/to/{model_save_dir} --batch_size=512 --num_gpus=4  --use_synthetic_data=false  --train_epochs=90  --dtype=fp32

打开xla:

    export PYTHONPATH=/home/resnet50_tensorflow:$PYTHONPATH
    TF_XLA_FLAGS="--tf_xla_auto_jit=1" python3 official/legacy/image_classification/resnet/resnet_ctl_imagenet_main.py --data_dir=/path/to/{ImageNet-tensorflow_data_dir} --model_dir=/path/to/{model_save_dir} --batch_size=512 --num_gpus=4  --train_epochs=90  --use_synthetic_data=false --dtype=fp32

#### 多机多卡训练指令(以单机四卡模拟四卡四进程为例)：

sed指令只需要执行一次，添加支持多卡运行的代码

    sed -i '100 r configfile' official/legacy/image_classification/resnet/resnet_ctl_imagenet_main.py

不打开xla：

    export PYTHONPATH=/home/resnet50_tensorflow:$PYTHONPATH
    mpirun -np 4 --hostfile hostfile  -mca btl self,tcp  --allow-run-as-root  --bind-to none scripts-run/single_process.sh

打开xla：
    
    export PYTHONPATH=/home/resnet50_tensorflow:$PYTHONPATH
    mpirun -np 4 --hostfile hostfile  -mca btl self,tcp  --allow-run-as-root  --bind-to none scripts-run/single_process_xla.sh
    
### fp16训练
#### 单机单卡训练指令

不打开xla：
   
    export PYTHONPATH=/home/resnet50_tensorFlow:$PYTHONPATH
    python3 official/legacy/image_classification/resnet/resnet_ctl_imagenet_main.py --data_dir=/path/to/{ImageNet-tensorflow_data_dir} --model_dir=/path/to/{model_save_dir} --batch_size=128 --num_gpus=1  --use_synthetic_data=false --train_epochs=90  --dtype=fp16

打开xla：
  
    export PYTHONPATH=/home/resnet50_tensorflow:$PYTHONPATH
    TF_XLA_FLAGS="--tf_xla_auto_jit=1" python3 official/legacy/image_classification/resnet/resnet_ctl_imagenet_main.py --data_dir=/path/to/{ImageNet-tensorflow_data_dir} --model_dir=/path/to/{model_save_dir} --batch_size=128 --num_gpus=1  --train_epochs=90  --use_synthetic_data=false --dtype=fp16

#### 单机四卡训练指令

不打开xla:
  
    export PYTHONPATH=/home/resnet50_tensorflow:$PYTHONPATH
    python3 official/legacy/image_classification/resnet/resnet_ctl_imagenet_main.py --data_dir=/path/to/{ImageNet-tensorflow_data_dir} --model_dir=/path/to/{model_save_dir} --batch_size=512 --num_gpus=4  --train_epochs=90  --use_synthetic_data=false --dtype=fp16

打开xla：
    
    export PYTHONPATH=/home/resnet50_tensorflow:$PYTHONPATH
    TF_XLA_FLAGS="--tf_xla_auto_jit=1" python3 official/legacy/image_classification/resnet/resnet_ctl_imagenet_main.py --data_dir=/path/to/{ImageNet-tensorflow_data_dir} --model_dir=/path/to/{model_save_dir} --batch_size=512 --num_gpus=4  --train_epochs=90  --use_synthetic_data=false --dtype=fp16

#### 多机多卡训练指令(以单机四卡模拟四卡四进程为例)

sed指令只需要执行一次，添加支持多卡运行的代码
    
    sed -i '100 r configfile' official/legacy/image_classification/resnet/resnet_ctl_imagenet_main.py

修改scripts-run/single_process.sh和scripts-run/single_process_xla.sh文件里的--dtype=fp16

不打开xla:

    export PYTHONPATH=/home/resnet50_tensorflow:$PYTHONPATH
    mpirun -np 4 --hostfile hostfile  -mca btl self,tcp  --allow-run-as-root  --bind-to none scripts-run/single_process.sh

打开xla：
 
    export PYTHONPATH=/home/resnet50_tensorflow:$PYTHONPATH
    mpirun -np 4 --hostfile hostfile  -mca btl self,tcp  --allow-run-as-root  --bind-to none scripts-run/single_process_xla.sh

### result
![img](./doc/ILSVRC2012_val_00001915.PNG)
![img](./doc/ILSVRC2012_val_00003386.PNG)

## 精度
测试数据：[ImageNet的测试数据集](https://image-net.org/ "ImageNet数据集官网")，使用的加速卡:DCU-Z100-16G

| 卡数 | batch size | 类型 |  Accuracy | 是否打开xla | 进程数 |
| :------: | :------: |  :------: | :------: | :------:| -------- |
| 4 | 512 | fp32 |  0.763  | 否 | 单进程 |
| 4 | 512 | fp16 |  0.764  | 否 | 单进程 |
| 4 | 512 | fp32 |  0.764  | 否 | 四进程 |
| 4 | 512 | fp16 |  0.763  | 否 | 四进程 |

## 应用场景
### 算法类别
`图像分类`
### 热点应用行业
`制造,政府,医疗,科研`

## 源码仓库及问题反馈
* https://developer.hpccube.com/codes/modelzoo/resnet50_tensorflow

## 参考
* https://github.com/tensorflow/models/tree/master
* https://www.tensorflow.org/api_docs/python/tf/distribute/MultiWorkerMirroredStrategy
