# Crown-of-Thorns Starfish Detection Pipeline

[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/tensorflow/models/blob/master/official/projects/cots_detector/crown_of_thorns_starfish_detection_pipeline.ipynb?force_crab_mode=1)

This repository shows how to detect crown-of-thorns starfish (COTS) using a
pre-trained COTS detector implemented in TensorFlow.

![Underwater photo of coral reef with annotated boxes identifying detected
starfish](https://storage.googleapis.com/download.tensorflow.org/data/cots_detection/COTS_detected_sample.png)

## Description

Coral reefs are some of the most diverse and important ecosystems in the world,
however they face a number of rising threats that have resulted in massive
global declines. In Australia, outbreaks of the coral-eating crown-of-thorns
starfish (COTS) have been shown to cause major coral loss, with just 15 starfish
in a hectare being able to strip a reef of 90% of its coral tissue. While COTS
naturally exist in the Indo-Pacific, overfishing and excess run-off nutrients
have led to massive outbreaks that are devastating already vulnerable coral
communities.

Controlling COTS populations is critical to promoting coral growth and
resilience, so Google teamed up with Australia’s national science agency,
[CSIRO](https://www.csiro.au/en/), to tackle this problem. We trained ML object
detection models to help scale underwater surveys, enabling the monitoring and
mapping out these harmful invertebrates with the ultimate goal of helping
control teams to address and prioritize outbreaks.

## Get started

[Open the notebook in Colab](https://colab.research.google.com/github/tensorflow/models/blob/master/official/projects/cots_detector/crown_of_thorns_starfish_detection_pipeline.ipynb?force_crab_mode=1)
to run the COTS detection pipeline.
