# TensorFlow Model Garden Modeling Projects

This directory contains projects using Modeling libraries of TensorFlow Model
Garden. More details about each project can be found in the individual
project folders listed below.

## Projects

* [AssembleNet](./assemblenet/README.md)
* [BASNet](./basnet/README.md)
* [BigBird](./bigbird/README.md)
* [DeepMAC Mask-RCNN](./deepmac_maskrcnn/README.md)
* [DETR](./detr/README.md)
* [Edge-TPU for Vision and NLP](./edgetpu/README.md)
* [Language-agnostic BERT Sentence Embedding](./labse/README.md)
* [Long-Document Transformer](./longformer/README.md)
* [MobileBERT](./mobilebert/README.md)
* [MoViNets](./movinet/README.md)
* [News Headline Generation Model: NHNet](./nhnet/README.md)
* [Training with Pruning](./pruning/README.md)
* [QAT for Computer Vision](./qat/vision/README.md)
* [Roformer Project](./roformer/README.md)
* [Training ELECTRA Augmented with Multi-word Selection](./teams/README.md)
* [NLP example project](./text_classification_example/README.md)
* [TensorNetwork BERT](./tn_bert/README.md)
* [Token Dropping for Efficient BERT Pretraining](./token_dropping/README.md)
* [Spatiotemporal Contrastive Video Representation Learning](./video_ssl/README.md)
* [Vision Transformer (ViT)](./vit/README.md)
* [Data-Efficient Image Transformer (DEIT)](./vit/README.md)
* [Volumetric Models](./volumetric_models/README.md)
* [YouTube-8M Tensorflow Starter Code](./yt8m/README.md)
