# TensorFlow Models

This repository contains machine learning models implemented in
[TensorFlow](https://tensorflow.org). The models are maintained by their
respective authors.

To propose a model for inclusion please submit a pull request.


## Models
- [autoencoder](autoencoder) -- various autoencoders.
- [compression](compression) -- compressing and decompressing images using pre-trained Residual GRU network.
- [differential_privacy](differential_privacy) -- privacy-preserving student models from multiple teachers.
- [im2txt](im2txt) -- image-to-text neural network for image captioning.
- [lm_1b](lm_1b) -- language modelling on one billion word benchmark.
- [inception](inception) -- deep convolutional networks for computer vision.
- [namignizer](namignizer) -- recognize and generate names.
- [neural_gpu](neural_gpu) -- highly parallel neural computer.
- [neural_programmer](neural_programmer) -- neural network augmented with logic and mathematic operations.
- [next_frame_prediction](next_frame_prediction) --  probabilistic future frame synthesis via cross convolutional networks.
- [real_nvp](real_nvp) -- density estimation using real-valued non-volume preserving (real NVP).
- [resnet](resnet) -- deep and wide residual networks.
- [slim](slim) -- image classification models in TF-Slim.
- [street](street) -- identify the name of a street (in France) from an image using Deep RNN.
- [swivel](swivel) -- the Swivel algorithm for generating word embeddings.
- [syntaxnet](syntaxnet) -- neural models of natural language syntax.
- [textsum](textsum) -- sequence-to-sequence with attention model for text summarization.
- [transformer](transformer) -- spatial transformer network, which allows the spatial manipulation of data within the network.
- [tutorials](tutorials) -- models referenced to from the [TensorFlow tutorials](https://www.tensorflow.org/tutorials/).
- [video_prediction](video_prediction) -- predicting future video frames with neural advection.
