#ifndef __CLASSIFIER_H__
#define __CLASSIFIER_H__

#include <onnxruntime_cxx_api.h>
#include <CommonDefinition.h>

namespace ortSamples
{
class  Classifier
{
public:
    Classifier();
    
    ~Classifier();

    ErrorCode Initialize(InitializationParameterOfClassifier initializationParameterOfClassifier);

    ErrorCode Classify(const std::vector<cv::Mat> &srcImages,std::vector<std::vector<ResultOfPrediction>> &predictions);

private:
    cv::FileStorage configurationFile;
    Ort::Session *dcu_session;
    Ort::Env env = Ort::Env(ORT_LOGGING_LEVEL_ERROR, "MIGraphX");
    Ort::SessionOptions sessionOptions = Ort::SessionOptions();

    std::vector<Ort::AllocatedStringPtr> inputNamesPtr;
    std::vector<Ort::AllocatedStringPtr> outputNamesPtr;
};
}

#endif

