# ResNet50
## 论文
`Deep Residual Learning for Image Recognition`

- https://arxiv.org/abs/1512.03385

## 模型结构
ResNet50模型包含了49个卷积层、一个全连接层。

![ResNet50模型结构](./Doc/images/1.png)

## 算法原理
ResNet50使用了多个具有残差连接的残差块来解决梯度消失或梯度爆炸问题，并使得网络可以向更深层发展。

![算法原理](./Doc/images/2.png)

## 环境配置
### Docker（方法一）
拉取镜像：
```python

```

创建并启动容器：
```

```
### Dockerfile（方法二）
```

```

## 数据集

无
<!--
下载ImageNet数据集：[ImageNet (image-net.org)](https://image-net.org/)  数据集快速下载通道[ImageNet](http://113.200.138.88:18080/aidatasets/project-dependency/imagenet-2012)

```
data
    |
    train
        |
        n01440764
        n01443537
        ...
    val
        |
        n01440764
        n01443537
        ...
```
-->
## 推理
### Python版本推理
采用ONNXRuntime框架使用DCU进行migraphx后端推理。
#### 配置环境
```python
# 进入resnet50 onnxruntime工程根目录
cd <path_to_resnet50_onnxruntime_migraphx> 

# 安装依赖
pip install -r ./Python/requirements.txt
```
#### 运行示例

本示例程序中一共给出了三种推理方式：

```python
# 进入resnet50 onnxruntime工程根目录
cd <path_to_resnet50_onnxruntime_migraphx> 

# 进入示例程序目录
cd Python/

# 静态推理，输入输出为cpu数据
python Classifier.py --staticInfer

# 动态推理，输入输出为cpu数据
python Classifier.py --dynamicInfer

# 静态推理，输入为gpu数据，输出为cpu数据
python Classifier_run_with_ort.py --staticInfer

# 动态推理，输入为gpu数据，输出为cpu数据
python Classifier_run_with_ort.py --dynamicInfer

# 静态推理，输入输出为gpu数据
python Classifier_io_binding.py
```

### C++版本推理
采用ONNXRuntime框架使用DCU进行推理，下面介绍如何运行C++代码示例。
#### 构建工程
```c++
cd <path_to_resnet50_onnxruntime_migraphx>

rbuild build -d depend
```
#### 设置环境变量
将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：
```c++
export LD_LIBRARY_PATH=<path_to_resnet50_onnxruntime_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```
然后执行:
```
source ~/.bashrc
```

#### 运行示例
```c++
# 进入resnet50_onnxruntime工程根目录
cd <path_to_resnet50_onnxruntime> 

# 进入build目录
cd build/

# 执行示例程序
./ResNet50
```
## result
### python版本

![result](./Doc/images/output_image.jpg)
### C++版本

![result](./Doc/images/output_image.jpg)
### 精度
无

## 应用场景
### 算法类别
`图像分类`

### 热点应用行业
`制造,政府,医疗,科研`

## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/resnet50_onnxruntime

## 参考资料
https://github.com/onnx/models/tree/main/vision/classification/resnet

