// 常用工具

#ifndef __COMMON_UTILITY_H__
#define __COMMON_UTILITY_H__

#include <CommonDefinition.h>

using namespace cv;
using namespace cv::dnn;

namespace ortSamples
{

enum DataLayout
    {
        DNN_LAYOUT_UNKNOWN = 0,
        DNN_LAYOUT_ND = 1,        //!< OpenCV data layout for 2D data.
        DNN_LAYOUT_NCHW = 2,      //!< OpenCV data layout for 4D data.
        DNN_LAYOUT_NCDHW = 3,      //!< OpenCV data layout for 5D data.
        DNN_LAYOUT_NHWC = 4,      //!< Tensorflow-like data layout for 4D data.
        DNN_LAYOUT_NDHWC = 5,      //!< Tensorflow-like data layout for 5D data.
        DNN_LAYOUT_PLANAR = 6,     //!< Tensorflow-like data layout, it should only be used at tf or tflite model parsing.
    };

    enum ImagePaddingMode
    {
        DNN_PMODE_NULL = 0,        // !< Default. Resize to required input size without extra processing.
        DNN_PMODE_CROP_CENTER = 1, // !< Image will be cropped after resize.
        DNN_PMODE_LETTERBOX = 2,   // !< Resize image to the desired size while preserving the aspect ratio of original image.
    };

    struct Image2BlobParams
    {
        Image2BlobParams():scalefactor(Scalar::all(1.0)), size(Size()), mean(Scalar()), swapRB(false), ddepth(CV_32F),
                           datalayout(DNN_LAYOUT_NCHW), paddingmode(DNN_PMODE_NULL)
        {}

        Image2BlobParams(const Scalar& scalefactor_, const Size& size_, const Scalar& mean_, bool swapRB_,
                         int ddepth_, DataLayout datalayout_, ImagePaddingMode mode_):
        scalefactor(scalefactor_), size(size_), mean(mean_), swapRB(swapRB_), ddepth(ddepth_),
        datalayout(datalayout_), paddingmode(mode_)
        {}

        Scalar scalefactor; //!< scalefactor multiplier for input image values.
        Size size;    //!< Spatial size for output image.
        Scalar mean;  //!< Scalar with mean values which are subtracted from channels.
        bool swapRB;  //!< Flag which indicates that swap first and last channels
        int ddepth;   //!< Depth of output blob. Choose CV_32F or CV_8U.
        DataLayout datalayout; //!< Order of output dimensions. Choose DNN_LAYOUT_NCHW or DNN_LAYOUT_NHWC.
        ImagePaddingMode paddingmode;   //!< Image padding mode. @see ImagePaddingMode.
    };

void blobFromImagesWithParams(InputArrayOfArrays images_, OutputArray blob_, const Image2BlobParams& param);

}

#endif
