# 分类器



本示例通过ResNet50模型说明如何使用ONNX Runtime C++ API进行分类模型的推理，包括如何预处理、推理并获取推理结果。



## 模型简介

本示例使用了经典的ResNet50模型，onnx文件在Resource/Models/文件夹下，模型结构可以通过netron (https://netron.app/) 查看，该模型的输入shape为[1,3,224,224] ，数据排布为NCHW。

​																														

## 预处理

在将数据输入到模型之前，需要对图像做如下预处理操作：

- 图像格式转换，BGR转换为RGB

- 调整图像大小，并在中心窗口位置裁剪出224x224大小的图像

- normalize操作，对图像减均值再除方差

- 转换数据排布为NCHW

  

本示例代码主要采用了OpenCV实现了预处理操作：

```c++
ErrorCode Classifier::Classify(const std::vector<cv::Mat> &srcImages,std::vector<std::vector<ResultOfPrediction>> &predictions)
{
	...
	
    // 预处理
    std::vector<cv::Mat> image;
    for(int i =0;i<srcImages.size();++i)
    {
        //BGR转换为RGB
        cv::Mat imgRGB;
        cv::cvtColor(srcImages[i], imgRGB, cv::COLOR_BGR2RGB);

        // 调整大小，保持长宽比
        cv::Mat shrink;
        float ratio = (float)256 / min(imgRGB.cols, imgRGB.rows);
        if(imgRGB.rows > imgRGB.cols)
        {
            cv::resize(imgRGB, shrink, cv::Size(256, int(ratio * imgRGB.rows)), 0, 0);
        }
        else
        {
            cv::resize(imgRGB, shrink, cv::Size(int(ratio * imgRGB.cols), 256), 0, 0);
        }

        // 裁剪中心窗口
        int start_x = shrink.cols/2 - 224/2;
        int start_y = shrink.rows/2 - 224/2;
        cv::Rect rect(start_x, start_y, 224, 224);
        cv::Mat images = shrink(rect);
        image.push_back(images);
    }

    // normalize并转换为NCHW
    cv::Mat inputBlob;
    Image2BlobParams image2BlobParams;
    image2BlobParams.scalefactor=cv::Scalar(1/58.395, 1/57.12, 1/57.375);
    image2BlobParams.mean=cv::Scalar(123.675, 116.28, 103.53);
    image2BlobParams.swapRB=false;
    blobFromImagesWithParams(image,inputBlob,image2BlobParams);
                    
     ...
}
```

blobFromImagesWithParams()函数支持多个输入图像，首先对输入图像各通道减对应的均值，然后乘以各通道对应的缩放系数，最后转换为NCHW，最终将转换好的数据保存到inputBlob中，然后就可以输入到模型中执行推理了。



## 推理

完成预处理后，就可以执行推理了：

```c++
ErrorCode Classifier::Classify(const std::vector<cv::Mat> &srcImages,std::vector<std::vector<ResultOfPrediction>> &predictions)
{
	...
	
	// 预处理


    // 创建输入数据
    std::array<int64_t, 4> inputShape{1, 3, 224, 224};
    auto memoryInfo = Ort::MemoryInfo::CreateCpu(OrtArenaAllocator, OrtMemTypeDefault);
    std::array<float, 3 * 224 * 224> input_image{};
    float* input_test = (float*)inputBlob.data;
    Ort::Value inputTensor = Ort::Value::CreateTensor<float>(memoryInfo, input_test, input_image.size(), inputShape.data(), inputShape.size());
    std::vector<Ort::Value> intput_tensors;
    intput_tensors.push_back(std::move(inputTensor));
    
    // 推理
    auto output_tensors = session->Run(Ort::RunOptions{nullptr}, input_node_names.data(), intput_tensors.data(), 1, output_node_names.data(), 1);
    
    // 获取输出节点的属性
    const float* pdata = output_tensors[0].GetTensorMutableData<float>(); // 获取第一个输出节点的数据
   	
   	...
   	
}
```

- input_node_names为一个字符串数组，包含输入节点的名称。intput_tensors表示一个OrtValue类型的指针数组，包含输入节点的值。"1"为输入节点的数量。output_node_names为一个字符串数组，包含输出节点的名称。最后一个1为输出节点的数量。
- session->Run(...)返回模型的推理结果，由于这里只有一个输出节点，所以返回数据中只有一个数据，output_tensors[0]表示第一个输出节点，这里对应resnetv24_dense0_fwd节点，获取输出数据。


