# ResNet50
## 论文
`Deep Residual Learning for Image Recognition`

- https://arxiv.org/abs/1512.03385

## 模型结构
ResNet50模型包含了49个卷积层、一个全连接层。

![ResNet50模型结构](./Doc/images/1.png)

## 算法原理
ResNet50使用了多个具有残差连接的残差块来解决梯度消失或梯度爆炸问题，并使得网络可以向更深层发展。

![算法原理](./Doc/images/2.png)

## 环境配置
### Docker（方法一）
拉取镜像：
```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

创建并启动容器：
```
docker run --shm-size 16g --network=host --name=resnet50_ort --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/resnet50_onnxruntime:/home/resnet50_onnxruntime -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```
### Dockerfile（方法二）
```
cd ./docker
docker build --no-cache -t resnet50_onnxruntime:2.0 .

docker run --shm-size 16g --network=host --name=resnet50_ort --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/resnet50_onnxruntime:/home/resnet50_onnxruntime -it <Your Image ID> /bin/bash
```

## 数据集
下载ImageNet数据集：[ImageNet (image-net.org)](https://image-net.org/)

```
data
    |
    train
        |
        n01440764
        n01443537
        ...
    val
        |
        n01440764
        n01443537
        ...
```

## 推理
### Python版本推理
采用ONNXRuntime框架使用DCU进行推理，下面介绍如何运行python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。
#### 配置环境
```python
# 进入resnet50 onnxruntime工程根目录
cd <path_to_resnet50_onnxruntime> 

# 安装依赖
pip install -r ./Python/requirements.txt
```
#### 运行示例
```python
# 进入resnet50 onnxruntime工程根目录
cd <path_to_resnet50_onnxruntime> 

# 进入示例程序目录
cd Python/

# 运行示例
python Classifier.py
```

### C++版本推理
采用ONNXRuntime框架使用DCU进行推理，下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。
#### 构建工程
```c++
cd <path_to_resnet50_onnxruntime>

# 安装Opencv依赖
sh ./3rdParty/InstallOpenCVDependences.sh

rbuild build -d depend
```
#### 设置环境变量
将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：
```c++
export LD_LIBRARY_PATH=<path_to_resnet50_onnxruntime>/depend/lib64/:$LD_LIBRARY_PATH
```
然后执行:
```
source ~/.bashrc
```

#### 运行示例
```c++
# 进入resnet50_onnxruntime工程根目录
cd <path_to_resnet50_onnxruntime> 

# 进入build目录
cd build/

# 执行示例程序
./ResNet50
```
## result
### python版本

![result](./Doc/images/output_image.jpg)
### C++版本

![result](./Doc/images/output_image.jpg)
### 精度
无

## 应用场景
### 算法类别
`图像分类`

### 热点应用行业
`制造,政府,医疗,科研`

## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/resnet50_onnxruntime

## 参考资料
https://github.com/onnx/models/tree/main/vision/classification/resnet

