#ifndef __CLASSIFIER_H__
#define __CLASSIFIER_H__


#include <onnxruntime/core/session/onnxruntime_cxx_api.h>

#include <CommonDefinition.h>

namespace ortSamples
{

class  Classifier
{
public:
    Classifier();
    
    ~Classifier();

    ErrorCode Initialize(InitializationParameterOfClassifier initializationParameterOfClassifier);

    ErrorCode Classify(const std::vector<cv::Mat> &srcImages,std::vector<std::vector<ResultOfPrediction>> &predictions);

private:
    cv::FileStorage configurationFile;
    

    Ort::Session *session;

    cv::Size inputSize;
    std::string inputName;
    Ort::Env env = Ort::Env(ORT_LOGGING_LEVEL_ERROR, "ONNXRuntime");
    Ort::SessionOptions sessionOptions = Ort::SessionOptions();

    bool useInt8;
    bool useFP16;
    

};

}

#endif

