# ResNet50

## 模型介绍
使用ONNXRuntime推理框架对ResNet50模型进行推理。

## 模型结构
ResNet50模型包含了49个卷积层、一个全连接层。

## Python版本推理
采用ONNXRuntime框架使用DCU进行推理，模型文件下载链接：https://github.com/onnx/models/blob/main/vision/classification/resnet/model/resnet50-v2-7.onnx，执行sh ./Resource/Models/download.sh 可以下载模型并将resnet50-v2-7.onnx模型文件保存在Resource/文件夹下。下面介绍如何运行python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。
### 下载镜像

在光源中下载ONNXRuntime推理框架镜像： 

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 设置Python环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

### 安装依赖

```python
# 进入resnet50 ort工程根目录
cd <path_to_resnet50_ort> 

# 进入示例程序目录
cd Python/

# 安装依赖
pip install -r requirements.txt
```

### 运行示例

```python
python Classifier.py
```

## C++版本推理

采用ONNXRuntime框架使用DCU进行推理，模型文件下载链接：https://github.com/onnx/models/blob/main/vision/classification/resnet/model/resnet50-v2-7.onnx ，执行sh ./Resource/Models/download.sh 可以下载模型并将resnet50-v2-7.onnx模型文件保存在Resource/文件夹下。下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。

### 下载镜像

在光源中下载ONNXRuntime推理框架镜像： 

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 安装Opencv依赖

```python
cd <path_to_resnet50_ort>
sh ./3rdParty/InstallOpenCVDependences.sh
```


### 安装OpenCV并构建工程

```
source /opt/dtk/env.sh

rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

```
export LD_LIBRARY_PATH=<path_to_resnet50_ort>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

### 运行示例

```python
# 进入resnet50 ort工程根目录
cd <path_to_resnet50_ort> 

# 进入build目录
cd build/

# 执行示例程序
./ResNet50
```


## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/resnet50_ort

## 参考

https://github.com/onnx/models/tree/main/vision/classification/resnet

