# ResNet50

## 模型介绍
使用MIGraphX推理框架对ResNet50模型进行推理。

## 模型结构
ResNet50模型包含了49个卷积层、一个全连接层。

## Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

### 下载镜像

在光源中下载MIGraphX镜像： 

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 设置Python环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

### 安装依赖

```python
# 进入resnet50 migraphx工程根目录
cd <path_to_resnet50_migraphx> 

# 进入示例程序目录
cd Python/

# 安装依赖
pip install -r requirements.txt
```

### 运行示例

在Python目录下执行如下命令运行该示例程序：

```python
python Classifier.py
```

输出结果中，每个值分别对应每个label的输出值。

```
[-2.07137913e-02  2.25237548e-01 -1.98313940e+00 -2.97359991e+00
 -1.61100197e+00  4.24269080e-01 -9.02939081e-01  1.21229446e+00
 ...
 -2.69769251e-01 -4.28011447e-01  1.25102985e+00  9.06333506e-01
 -1.08657002e-01  3.15954179e-01  1.94901276e+00 -5.70572793e-01]
```

## C++版本推理

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。

### 下载镜像

在光源中下载MIGraphX镜像： 

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 安装Opencv依赖

```python
cd <path_to_resnet50_migraphx>
sh ./3rdParty/InstallOpenCVDependences.sh
```

### 修改CMakeLists.txt

如果使用ubuntu系统，需要修改CMakeLists.txt中依赖库路径：
将"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/"修改为"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/"


### 安装OpenCV并构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

**Centos**:

```
export LD_LIBRARY_PATH=<path_to_resnet50_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

**Ubuntu**:

```
export LD_LIBRARY_PATH=<path_to_resnet50_migraphx>/depend/lib/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

### 运行示例

```python
# 进入resnet50 migraphx工程根目录
cd <path_to_resnet50_migraphx> 

# 进入build目录
cd ./build/

# 执行示例程序
./ResNet50
```

输出结果中，每个值分别对应每个label的输出值。

```
label:0,confidence:-0.020714
label:1,confidence:0.225238
label:2,confidence:-1.983140
label:3,confidence:-2.973601
label:4,confidence:-1.611002
label:5,confidence:0.424268
...
label:995,confidence:0.906333
label:996,confidence:-0.108658
label:997,confidence:0.315955
label:998,confidence:1.949013
label:999,confidence:-0.570573
```

## 历史版本

https://developer.hpccube.com/codes/modelzoo/resnet50_migraphx

## 参考资料

https://github.com/ROCmSoftwarePlatform/AMDMIGraphX/tree/develop/examples/vision/python_resnet50

