# ResNet50

## 模型介绍
使用MIGraphX推理框架对ResNet50模型进行推理。

## 模型结构
ResNet50模型包含了49个卷积层、一个全连接层。

## Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

### 下载镜像

下载MIGraphX镜像： 

```python
docker pull sugonhub/migraphx:3.2.1-centos7.6-dtk-23.04.1-py38
```

### 设置Python环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

### 安装依赖

```python
# 进入resnet50 migraphx工程根目录
cd <path_to_resnet50_migraphx> 

# 进入示例程序目录
cd Python/

# 安装依赖
pip install -r requirements.txt
```

### 运行示例

```python
python Classifier.py
```

## C++版本推理

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。

### 下载镜像

下载MIGraphX镜像： 

```
docker pull sugonhub/migraphx:3.2.1-centos7.6-dtk-23.04.1-py38
```

### 安装Opencv依赖

```python
cd <path_to_resnet50_migraphx>
sh ./3rdParty/InstallOpenCVDependences.sh
```


### 安装OpenCV并构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

```
export LD_LIBRARY_PATH=<path_to_resnet50_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

### 运行示例

```python
# 进入resnet50 migraphx工程根目录
cd <path_to_resnet50_migraphx> 

# 进入build目录
cd build/

# 执行示例程序
./ResNet50
```

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/resnet50_migraphx

## 参考

https://github.com/onnx/models/tree/main/vision/classification/resnet

