#ifndef __CLASSIFIER_H__
#define __CLASSIFIER_H__

#include <migraphx/program.hpp>

#include <CommonDefinition.h>

namespace migraphxSamples
{

class Classifier
{
    public:
    Classifier();

    ~Classifier();

    ErrorCode Initialize(InitializationParameterOfClassifier initializationParameterOfClassifier);

    cv::Mat Preprocess(const std::vector<cv::Mat>& srcImages);

    ErrorCode Classify(const std::vector<cv::Mat>& srcImages,
                       std::vector<std::vector<ResultOfPrediction>>& predictions);

    private:
    cv::FileStorage configurationFile;

    migraphx::program net;
    cv::Size inputSize;
    std::string inputName;
    migraphx::shape inputShape;
    std::string outputName;
    migraphx::shape outputShape;
    std::unordered_map<std::string, migraphx::argument> programParameters;

    void* inputBuffer_Device;
    void* outputBuffer_Device;
    void* outputBuffer_Host;

    bool useInt8;
    bool useFP16;
    bool useoffloadcopy;
};

} // namespace migraphxSamples

#endif
