# ResNet50

## 论文
Deep Residual Learning for Image Recognition

- https://arxiv.org/abs/1512.03385

## 模型结构
ResNet50模型包含了49个卷积层、一个全连接层。

<img src="./Doc/Images/ResNet50.png" style="zoom:80%;" align=middle>

## 算法原理

ResNet50使用了多个具有残差连接的残差块来解决梯度消失或梯度爆炸问题，并使得网络可以向更深层发展。

<img src="./Doc/Images/Residual_Block.png" style="zoom:100%;" align=middle>

## 环境配置

### Docker（方法一）

拉取镜像：

```plaintext
docker pull image.sourcefind.cn:5000/dcu/admin/base/migraphx:4.3.0-ubuntu20.04-dtk24.04.1-py3.10
```

创建并启动容器：

```plaintext
docker run --shm-size 16g --network=host --name=resnet50_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/resnet50_migraphx:/home/resnet50_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

### Dockerfile（方法二）

```plaintext
cd ./docker
docker build --no-cache -t resnet50_migraphx:2.0 .

docker run --shm-size 16g --network=host --name=resnet50_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/resnet50_migraphx:/home/resnet50_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集

根据需求上传所需图像，可以对相应图像进行分类。

## 推理

### Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

#### 设置环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

#### 运行示例

```python
# 进入resnet50 migraphx工程根目录
cd <path_to_resnet50_migraphx> 

# 进入示例程序目录
cd Python/

# 安装依赖
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
```

​	1.offload为true的模型推理

```
python Classifier.py
```

 	2.offload为false的模型推理

```
python Classifier_OffloadFalse.py
```

### C++版本推理

注意：当使用操作系统不一样时，CMakeList需要作相应的修改：

```
# ubuntu操作系统
${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/ 修改为 ${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/

# centos操作系统
${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/ 修改为 ${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/
```

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。

#### 安装Opencv依赖

```python
cd <path_to_resnet50_migraphx>
sh ./3rdParty/InstallOpenCVDependences.sh
```


#### 安装OpenCV并构建工程

```
rbuild build -d depend
```

#### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

当操作系统是ubuntu系统时：

```
export LD_LIBRARY_PATH=<path_to_yolov3_migraphx>/depend/lib/:$LD_LIBRARY_PATH
```

当操作系统是centos系统时：

```
export LD_LIBRARY_PATH=<path_to_resnet50_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

#### 运行示例

```python
# 进入resnet50 migraphx工程根目录
cd <path_to_resnet50_migraphx> 

# 进入build目录
cd build/

# 执行示例程序
./ResNet50
```

默认offload为true，如果想要offload为false，可以在./Resource/Configuration.xmlwen文件中修改Useoffloadcopy为1，再执行示例程序。

## result

### Python版本

输出结果中，每个值分别对应每个label的实际概率。

```
[[-2.07131356e-02  2.25237340e-01 -1.98313904e+00 -2.97360039e+00
  ...
  -1.08657278e-01  3.15954179e-01  1.94901395e+00 -5.70572257e-01]]
```

### C++版本

输出结果中，每个值分别对应每个label的实际概率。

```
label:0,confidence:-0.020714
label:1,confidence:0.225237
label:2,confidence:-1.983139
label:3,confidence:-2.973600
...
label:996,confidence:-0.108657
label:997,confidence:0.315954
label:998,confidence:1.949014
label:999,confidence:-0.570572
```

### 精度

无

## 应用场景

### 算法类别

图像分类

### 热点应用行业

制造,政府,医疗,科研

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/resnet50_migraphx

## 参考资料

https://github.com/onnx/models/tree/main/vision/classification/resnet

