#ifndef __CLASSIFIER_H__
#define __CLASSIFIER_H__

#include <string>
#include <migraphx/program.hpp>
#include <opencv2/opencv.hpp>
#include <CommonDefinition.h>

namespace migraphxSamples
{

class  Classifier
{
public:
    Classifier();
    
    ~Classifier();

    ErrorCode Initialize(InitializationParameterOfClassifier initializationParameterOfClassifier);

    ErrorCode Classify(const std::vector<cv::Mat> &srcImages,std::vector<std::vector<ResultOfPrediction>> &predictions);

private:
    ErrorCode DoCommonInitialization(InitializationParameterOfClassifier initializationParameterOfClassifier);

private:
    cv::FileStorage configurationFile;
    InitializationParameterOfClassifier initializationParameter;
    FILE *logFile;
    
    migraphx::program net;
    cv::Size inputSize;
    std::string inputName;
    migraphx::shape inputShape;

    float scale;
    cv::Scalar meanValue;
    bool swapRB;
    bool crop;
    bool useInt8;
    bool useFP16;    

};

}

#endif

