# ResNet50

## 模型介绍
使用MIGraphX推理框架对ResNet50模型进行推理。

## 模型结构
ResNet50模型包含了49个卷积层、一个全连接层。

## Python版本推理

下面介绍如何运行python代码示例，具体推理代码解析，在Doc/Tutorial_Python目录中有详细说明。

### 构建安装

在光源可拉取推理的docker镜像，ResNet50模型推理的镜像如下： 

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 推理示例

1.参考《MIGraphX教程》设置好PYTHONPATH

2.安装依赖：

```python
# 进入migraphx samples工程根目录
cd <path_to_migraphx_samples> 

# 进入示例程序目录
cd Python/

# 安装依赖
pip install -r requirements.txt
```

3.在Python目录下执行如下命令运行该示例程序：

```python
python Classifier.py
```

输出结果中，每个值分别对应每个label的输出值。

```
[ 1.25075293e+00  1.78420877e+00 -2.56109548e+00 -3.44433069e+00
 -2.66113567e+00  1.52841401e+00  7.93735325e-01 -1.26759931e-02
 ...
  4.39746976e-02  3.43239784e-01  2.75328755e+00  1.70684290e+00
  8.54880095e-01  2.12219620e+00  2.35758686e+00 -1.06204104e+00]
```

## C++版本推理

下面介绍如何运行C++代码示例，具体推理代码解析，在Doc/Tutorial_Cpp目录中有详细说明。

参考Python版本推理中的构建安装，在光源中拉取推理的docker镜像。

### 安装Opencv依赖

```python
cd <path_to_migraphx_samples>
sh ./3rdParty/InstallOpenCVDependences.sh
```

### 修改CMakeLists.txt

- 如果使用ubuntu系统，需要修改CMakeLists.txt中依赖库路径：
  将"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/"修改为"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/"

- **MIGraphX2.3.0及以上版本需要c++17**


### 安装OpenCV并构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

**Centos**:

```
export LD_LIBRARY_PATH=<path_to_migraphx_samples>/depend/lib64/:$LD_LIBRARY_PATH
```

**Ubuntu**:

```
export LD_LIBRARY_PATH=<path_to_migraphx_samples>/depend/lib/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

### 推理示例

运行ResNet50示例程序，具体执行如下命令：

```python
# 进入migraphx samples工程根目录
cd <path_to_migraphx_samples> 

# 进入build目录
cd ./build/

# 执行示例程序
./ResNet50
```

输出结果中，每个值分别对应每个label的输出值。

```
label:0,confidence:1.250770
label:1,confidence:1.784038
label:2,confidence:-2.561039
label:3,confidence:-3.444281
label:4,confidence:-2.661026
label:5,confidence:1.528260
...
label:995,confidence:1.706820
label:996,confidence:0.854793
label:997,confidence:2.121985
label:998,confidence:2.357481
label:999,confidence:-1.062007
```

## 历史版本

https://developer.hpccube.com/codes/modelzoo/classifier_migraphx

## 参考资料

https://github.com/ROCmSoftwarePlatform/AMDMIGraphX/tree/develop/examples/vision/python_resnet50

