#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <SimpleLog.h>
#include <Filesystem.h>
#include <Classifier.h>

int main()
{
    // 创建分类器
    migraphxSamples::Classifier classifier;
    migraphxSamples::InitializationParameterOfClassifier initParamOfClassifier;
    initParamOfClassifier.configFilePath=CONFIG_FILE;
    migraphxSamples::ErrorCode errorCode=classifier.Initialize(initParamOfClassifier);
    if(errorCode!=migraphxSamples::SUCCESS)
    {
        LOG_ERROR(stdout, "fail to initialize ResNet50!\n");
        exit(-1);
    }
    LOG_INFO(stdout, "succeed to initialize ResNet50\n");

    // 读取测试图片
    cv::Mat srcImage=cv::imread("../Resource/Images/ImageNet_01.jpg",1);

    // 设置batchsize
    int batchsize=1;
    std::vector<cv::Mat> srcImages;
    for(int i=0;i<batchsize;++i)
    {
        srcImages.push_back(srcImage);
    }

    // 推理
    std::vector<std::vector<migraphxSamples::ResultOfPrediction>> predictions;
    classifier.Classify(srcImages,predictions);

    // 获取推理结果
    LOG_INFO(stdout,"========== Classification Results ==========\n");
    for(int i=0;i<predictions.size();++i)
    {
        // 一个batch中第i幅图像的结果
        LOG_INFO(stdout,"========== %d result ==========\n",i);
        std::vector<migraphxSamples::ResultOfPrediction> resultOfPredictions=predictions[i];
        for(int j=0;j<resultOfPredictions.size();++j)
        {
            migraphxSamples::ResultOfPrediction prediction=resultOfPredictions[j];
            LOG_INFO(stdout,"label:%d,confidence:%f\n",prediction.label,prediction.confidence);
        }

    }

    return 0;
}