#ifndef __CLASSIFIER_H__
#define __CLASSIFIER_H__

#include <migraphx/program.hpp>

#include <CommonDefinition.h>

namespace migraphxSamples
{

class  Classifier
{
public:
    Classifier();
    
    ~Classifier();

    ErrorCode Initialize(InitializationParameterOfClassifier initializationParameterOfClassifier);

    ErrorCode Classify(const std::vector<cv::Mat> &srcImages,std::vector<std::vector<ResultOfPrediction>> &predictions);

private:
    cv::FileStorage configurationFile;
    
    migraphx::program net;
    cv::Size inputSize;
    std::string inputName;
    migraphx::shape inputShape;

    float scale;
    cv::Scalar meanValue;
    bool swapRB;
    bool crop;
    bool useInt8;
    bool useFP16;
    

};

}

#endif

