# ResNet50

## 模型介绍

使用PyTorch进行ResNet50训练。

## 模型结构

ResNet50 网络中包含了 49 个卷积层、一个全连接层。

## 数据集

下载ImageNet数据集：[ImageNet (image-net.org)](https://image-net.org/)

参考[scrips/extract_ILSVRC.sh](https://developer.hpccube.com/codes/modelzoo/resnet50-pytorch/-/blob/main/scrips/extract_ILSVRC.sh)处理数据集。

## 训练

### 环境配置

从[光源](https://www.sourcefind.cn/#/service-details)拉取训练镜像：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
```

安装依赖：

```
pip3 install -r requirements.txt
```

### 单卡训练（单精度）

```
export HIP_VISIBLE_DEVICES=0
python3 main_acc.py --batch-size=64 --arch=resnet50 -j 6 --epochs=90 --save-path=/path/to/{save_model_dir} /path/to/{ImageNet_pytorch_data_dir}/
```

其中，'/path/to/{save_model_dir}' 修改为model 想要保存的路径，'/path/to/{ImageNet_pytorch_data_dir}/'修改为ImageNet数据集所在路径，后续混合精度训练与多卡训练脚本修改相同，不再说明。

### 单卡训练（混合精度）

```
export HIP_VISIBLE_DEVICES=0
python3 main_acc.py --batch-size=64 --arch=resnet50 -j 6 --epochs=90 --amp --opt-level O1 --loss-scale=dynamic --save-path=/path/to/{save_model_dir} /path/to/{ImageNet_pytorch_data_dir}/
```

### 单机四卡测试（单精度）

```
mpirun --allow-run-as-root --bind-to none -np 4 scrips/single_process.sh localhost resnet50 64
```

## 性能和准确率数据

测试数据使用ImageNet数据集，使用的加速卡是DCUZ100L。

| 卡数 | batch size | 类型 | 性能 | Accuracy(%) |
| ---- | ---------- | ---- | ---- | ----------- |
| 4    | 256        | fp32 | -    | 75.94       |
| 4    | 256        | amp  | -    | 75.99       |

# 参考

https://github.com/pytorch/examples/tree/master/imagenet